/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;

public class StringsExtractor {
    protected DocumentModel document;
    protected Set<String> includedPaths;
    protected Set<String> excludedPaths;
    protected List<String> strings;

    public List<String> findStrings(DocumentModel document, Set<String> includedPaths, Set<String> excludedPaths) {
        this.document = document;
        this.includedPaths = includedPaths;
        this.excludedPaths = excludedPaths;
        this.strings = new ArrayList<String>();
        for (String schema : document.getSchemas()) {
            for (Property property : document.getPropertyObjects(schema)) {
                Object path = property.getField().getName().getPrefixedName();
                if (!((String)path).contains(":")) {
                    path = property.getSchema().getName() + ":" + (String)path;
                }
                this.findStrings(property, (String)path);
            }
        }
        return this.strings;
    }

    protected boolean isInterestingPath(String path) {
        if (this.excludedPaths != null && this.excludedPaths.contains(path)) {
            return false;
        }
        return this.includedPaths == null || this.includedPaths.contains(path);
    }

    protected void findStrings(Property property, String path) {
        block7: {
            block8: {
                Serializable value;
                block6: {
                    Serializable value2;
                    if (!(property instanceof StringProperty)) break block6;
                    if (!this.isInterestingPath(path) || !((value2 = property.getValue()) instanceof String)) break block7;
                    this.strings.add((String)((Object)value2));
                    break block7;
                }
                if (!(property instanceof ArrayProperty)) break block8;
                if (!this.isInterestingPath(path) || !((value = property.getValue()) instanceof Object[])) break block7;
                for (Object v : (Object[])value) {
                    if (!(v instanceof String)) continue;
                    this.strings.add((String)v);
                }
                break block7;
            }
            if (property instanceof ComplexProperty) {
                for (Property p : ((ComplexProperty)property).getChildren()) {
                    String pp = p.getField().getName().getPrefixedName();
                    this.findStrings(p, path + "/" + pp);
                }
            } else if (property instanceof ListProperty) {
                for (Property p : (ListProperty)property) {
                    this.findStrings(p, path + "/*");
                }
            }
        }
    }
}

