/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="type")
public class SubType {
    @XNode
    protected String name;
    protected Set<String> hidden = new HashSet<String>();

    public SubType() {
    }

    public SubType(String name, Set<String> hidden) {
        this.name = name;
        if (hidden != null) {
            this.hidden.addAll(hidden);
        }
    }

    public List<String> getHidden() {
        if (this.hidden == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.hidden);
    }

    @XNode(value="@hidden")
    public void setHidden(String value) {
        String[] hiddenCases = value.split("(\\s+)(?=[^,])|(\\s*,\\s*)");
        this.hidden = new HashSet<String>(Arrays.asList(hiddenCases));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{SubType: " + this.name + ", hidden: " + this.hidden + "}";
    }
}

