/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.xerces.dom.DocumentImpl;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.schema.DocTypeRegistry;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeRegistry
extends MapRegistry {
    protected static XAnnotatedObject xCoreType;

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        super.register(ctx, xObject, element, tag);
        this.registerCoreContribution(ctx, element, tag);
    }

    public void unregister(String tag) {
        super.unregister(tag);
        this.getCoreRegistry().unregister(tag);
    }

    protected <T> T getMergedInstance(Context ctx, XAnnotatedObject xObject, Element element, Object existing) {
        Type merged = (Type)super.getMergedInstance(ctx, xObject, element, existing);
        Set<String> denied = Set.of(merged.getDeniedSubTypes());
        merged.getAllowedSubTypes().keySet().removeIf(Predicate.not(denied::contains));
        return (T)merged;
    }

    public boolean hasType(String id) {
        return this.getContribution(id).isPresent();
    }

    public Collection<Type> getTypes() {
        return this.getContributionValues();
    }

    public Type getType(String id) {
        return this.getContribution(id).orElse(null);
    }

    protected void recomputeTypes() {
        List types = this.getContributionValues();
        for (Type type : types) {
            type.setAllowedSubTypes(this.getCoreAllowedSubtypes(type));
            type.setDeniedSubTypes(new String[0]);
        }
    }

    protected Map<String, SubType> getCoreAllowedSubtypes(Type type) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Set coreAllowedSubtypes = schemaManager.getAllowedSubTypes(type.getId());
        if (coreAllowedSubtypes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SubType> res = new HashMap<String, SubType>();
        Map<String, SubType> subTypes = type.getAllowedSubTypes();
        for (String name : coreAllowedSubtypes) {
            SubType subtype = subTypes.get(name);
            if (subtype == null) {
                res.put(name, new SubType(name, null));
                continue;
            }
            res.put(name, subtype);
        }
        return res;
    }

    protected DocTypeRegistry getCoreRegistry() {
        return (DocTypeRegistry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.ecm.core.schema.TypeService", "doctype").orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", "org.nuxeo.ecm.core.schema.TypeService", "doctype")));
    }

    protected void registerCoreContribution(Context ctx, Element element, String tag) {
        Node st = DOMHelper.getElementNode((Node)element, (String)"subtypes");
        Node dst = DOMHelper.getElementNode((Node)element, (String)"deniedSubtypes");
        if (!element.hasAttribute("id")) {
            return;
        }
        DocumentImpl xmlDoc = new DocumentImpl();
        Element root = xmlDoc.createElement("doctype");
        root.setAttribute("name", element.getAttribute("id"));
        this.maybeCopyAttribute(element, root, "remove");
        this.maybeCopyAttribute(element, root, "merge");
        this.maybeCopyAttribute(element, root, "enable");
        if (st != null) {
            this.copyChildNode((Document)xmlDoc, st, root, "subtypes", "type");
        }
        if (dst != null) {
            this.copyChildNode((Document)xmlDoc, dst, root, "subtypes-forbidden", "type");
        }
        this.getCoreRegistry().registerDocumentType(ctx, xCoreType, root, tag);
    }

    protected void maybeCopyAttribute(Element orig, Element target, String name) {
        if (orig.hasAttribute(name)) {
            target.setAttribute(name, orig.getAttribute(name));
        }
    }

    protected void copyChildNode(Document xmlDoc, Node origChild, Element targetParent, String copyNodeName, String subNodeName) {
        Element copy = xmlDoc.createElement(copyNodeName);
        targetParent.appendChild(copy);
        NodeList origChildren = origChild.getChildNodes();
        for (int i = 0; i < origChildren.getLength(); ++i) {
            Node childNode = origChildren.item(i);
            if (!subNodeName.equals(childNode.getNodeName())) continue;
            this.cloneChildNode(xmlDoc, childNode, copy);
        }
    }

    protected void cloneChildNode(Document xmlDoc, Node origNode, Element targetParent) {
        Element clone = xmlDoc.createElement(origNode.getNodeName());
        targetParent.appendChild(clone);
        clone.appendChild(xmlDoc.createTextNode(origNode.getTextContent()));
    }

    static {
        XMap xmap = new XMap();
        xmap.register(DocumentTypeDescriptor.class);
        xCoreType = xmap.getObject(DocumentTypeDescriptor.class);
    }
}

