/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types.localconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;

public class UITypesConfigurationAdapter
extends AbstractLocalConfiguration<UITypesConfiguration>
implements UITypesConfiguration {
    private static final Log log = LogFactory.getLog(UITypesConfigurationAdapter.class);
    protected DocumentRef documentRef;
    protected List<String> allowedTypes;
    protected List<String> deniedTypes;
    protected boolean denyAllTypes;
    protected boolean canMerge = true;
    protected String defaultType;

    public UITypesConfigurationAdapter(DocumentModel doc) {
        this.documentRef = doc.getRef();
        this.allowedTypes = this.getTypesList(doc, "uitypesconf:allowedTypes");
        this.deniedTypes = this.getTypesList(doc, "uitypesconf:deniedTypes");
        this.defaultType = this.getDefaultType(doc);
        this.denyAllTypes = this.getDenyAllTypesProperty(doc);
        if (this.denyAllTypes) {
            this.canMerge = false;
        }
    }

    protected List<String> getTypesList(DocumentModel doc, String property) {
        String[] types;
        try {
            types = (String[])doc.getPropertyValue(property);
        }
        catch (PropertyException e) {
            return Collections.emptyList();
        }
        if (types == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(types));
    }

    protected boolean getDenyAllTypesProperty(DocumentModel doc) {
        try {
            Boolean value = (Boolean)doc.getPropertyValue("uitypesconf:denyAllTypes");
            return Boolean.TRUE.equals(value);
        }
        catch (PropertyException e) {
            return false;
        }
    }

    protected String getDefaultType(DocumentModel doc) {
        String value = "File";
        try {
            value = (String)((Object)doc.getPropertyValue("uitypesconf:defaultType"));
        }
        catch (PropertyException e) {
            log.debug((Object)("can't get default type for:" + doc.getPathAsString()), (Throwable)e);
        }
        return value;
    }

    @Override
    public List<String> getAllowedTypes() {
        return this.allowedTypes;
    }

    @Override
    public List<String> getDeniedTypes() {
        return this.deniedTypes;
    }

    @Override
    public boolean denyAllTypes() {
        return this.denyAllTypes;
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    public boolean canMerge() {
        return this.canMerge;
    }

    public UITypesConfiguration merge(UITypesConfiguration other) {
        if (other == null) {
            return this;
        }
        this.documentRef = other.getDocumentRef();
        if (this.allowedTypes.isEmpty()) {
            this.allowedTypes = Collections.unmodifiableList(new ArrayList<String>(other.getAllowedTypes()));
        }
        ArrayList<String> dTypes = new ArrayList<String>(this.deniedTypes);
        dTypes.addAll(other.getDeniedTypes());
        this.deniedTypes = Collections.unmodifiableList(dTypes);
        this.denyAllTypes = other.denyAllTypes();
        if (this.denyAllTypes) {
            this.canMerge = false;
        }
        return this;
    }

    @Override
    public Map<String, SubType> filterSubTypes(Map<String, SubType> allowedSubTypes) {
        if (this.denyAllTypes) {
            return Collections.emptyMap();
        }
        if (this.allowedTypes.isEmpty() && this.deniedTypes.isEmpty()) {
            return allowedSubTypes;
        }
        HashMap<String, SubType> filteredAllowedSubTypes = new HashMap<String, SubType>(allowedSubTypes);
        filteredAllowedSubTypes.keySet().removeIf(subTypeName -> this.deniedTypes.contains(subTypeName) || !this.allowedTypes.isEmpty() && !this.allowedTypes.contains(subTypeName));
        return filteredAllowedSubTypes;
    }

    @Override
    public Collection<String> filterSubTypes(Collection<String> allowedSubTypes) {
        if (this.denyAllTypes) {
            return Collections.emptyList();
        }
        if (this.allowedTypes.isEmpty() && this.deniedTypes.isEmpty()) {
            return allowedSubTypes;
        }
        ArrayList<String> filteredAllowedSubTypes = new ArrayList<String>(allowedSubTypes);
        filteredAllowedSubTypes.removeIf(subTypeName -> this.deniedTypes.contains(subTypeName) || !this.allowedTypes.isEmpty() && !this.allowedTypes.contains(subTypeName));
        return filteredAllowedSubTypes;
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }
}

