/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedReference;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNodes;
import org.w3c.dom.Element;

public class XAnnotatedMembers
extends XAnnotatedMember {
    protected XAnnotatedMember[] members;
    protected String separator;

    public XAnnotatedMembers(XMap xmap, XAccessor setter, XAnnotatedMember[] members, String separator, String defaultValue) {
        super(xmap, setter);
        this.init(xmap, setter, members, separator, defaultValue);
    }

    public XAnnotatedMembers(XMap xmap, XAccessor setter, XNodes anno) {
        this(xmap, setter, anno.values(), anno.separator(), anno.defaultAssignment());
    }

    public XAnnotatedMembers(XMap xmap, XAccessor setter, String[] values, String separator, String defaultValue) {
        super(xmap, setter);
        XAnnotatedMember[] members = (XAnnotatedMember[])Arrays.stream(values).map(value -> new XAnnotatedReference(xmap, String.class, (String)value, null, null)).toArray(XAnnotatedMember[]::new);
        this.init(xmap, setter, members, separator, defaultValue);
    }

    protected void init(XMap xmap, XAccessor setter, XAnnotatedMember[] members, String separator, String defaultValue) {
        this.members = members;
        this.separator = separator;
        this.defaultValue = defaultValue;
        this.type = setter != null ? setter.getType() : String.class;
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    @Override
    public boolean hasValue(Context ctx, Element element) {
        return Arrays.stream(this.members).anyMatch(member -> member.hasValue(ctx, element));
    }

    @Override
    public Object getValue(Context ctx, Element base) {
        ArrayList<String> values = new ArrayList<String>();
        for (XAnnotatedMember member : this.members) {
            if (!member.hasValue(ctx, base)) continue;
            Object mvalue = member.getValue(ctx, base);
            values.add(mvalue != null ? String.valueOf(mvalue) : "");
        }
        if (values.isEmpty()) {
            return this.getDefaultValue(ctx);
        }
        return String.join((CharSequence)this.separator, values);
    }

    @Override
    public void toXML(Object instance, Element parent) {
        Arrays.asList(this.members).forEach(member -> member.toXML(instance, parent));
    }
}

