/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBReferenceDescriptor;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;

@XObject(value="directory")
@XRegistry
public class MongoDBDirectoryDescriptor
extends BaseDirectoryDescriptor {
    @XNodeList(value="references/reference", type=MongoDBReferenceDescriptor[].class, componentType=MongoDBReferenceDescriptor.class)
    public MongoDBReferenceDescriptor[] mongodbReferences;

    public MongoDBReferenceDescriptor[] getMongoDBReferences() {
        return this.mongodbReferences;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof MongoDBDirectoryDescriptor) {
            this.merge((MongoDBDirectoryDescriptor)other);
        }
    }

    protected void merge(MongoDBDirectoryDescriptor other) {
        if (other.mongodbReferences != null && this.mongodbReferences.length != 0) {
            this.mongodbReferences = other.mongodbReferences;
        }
    }

    public MongoDBDirectoryDescriptor clone() {
        MongoDBDirectoryDescriptor clone = (MongoDBDirectoryDescriptor)super.clone();
        if (this.mongodbReferences != null) {
            clone.mongodbReferences = new MongoDBReferenceDescriptor[this.mongodbReferences.length];
            for (int i = 0; i < this.mongodbReferences.length; ++i) {
                clone.mongodbReferences[i] = this.mongodbReferences[i].clone();
            }
        }
        return clone;
    }

    public MongoDBDirectory newDirectory() {
        return new MongoDBDirectory(this);
    }
}

