/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.security.KeyStore;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http4.Http4FileSystem;
import org.apache.http.cookie.Cookie;

public class Http4FileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final Http4FileSystemConfigBuilder BUILDER = new Http4FileSystemConfigBuilder();
    private static final String MAX_TOTAL_CONNECTIONS = "http.connection-manager.max-total";
    private static final String MAX_HOST_CONNECTIONS = "http.connection-manager.max-per-host";
    private static final String CONNECTION_TIMEOUT = "http.connection.timeout";
    private static final String SO_TIMEOUT = "http.socket.timeout";
    private static final String KEEP_ALIVE = "http.keepAlive";
    private static final String KEYSTORE_FILE = "http.keystoreFile";
    private static final String KEYSTORE_PASS = "http.keystorePass";
    private static final String KEYSTORE_TYPE = "http.keyStoreType";
    private static final String HOSTNAME_VERIFICATION_ENABLED = "http.hostname-verification.enabled";
    protected static final String KEY_FOLLOW_REDIRECT = "followRedirect";
    private static final String KEY_USER_AGENT = "userAgent";
    private static final String KEY_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    private static final int DEFAULT_SO_TIMEOUT = 0;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
    private static final String DEFAULT_USER_AGENT = "Jakarta-Commons-VFS";
    private static final boolean DEFAULT_HOSTNAME_VERIFICATION_ENABLED = true;
    private static final String PROXY_SCHEME = "proxyScheme";

    protected Http4FileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    private Http4FileSystemConfigBuilder() {
        super("http.");
    }

    public static Http4FileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUrlCharset(FileSystemOptions opts, String chaset) {
        this.setParam(opts, "urlCharset", chaset);
    }

    public String getUrlCharset(FileSystemOptions opts) {
        return this.getString(opts, "urlCharset");
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", proxyPort);
    }

    public void setProxyScheme(FileSystemOptions opts, String proxyScheme) {
        this.setParam(opts, PROXY_SCHEME, proxyScheme);
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    public String getProxyScheme(FileSystemOptions opts) {
        return this.getString(opts, PROXY_SCHEME, "http");
    }

    public void setProxyAuthenticator(FileSystemOptions opts, UserAuthenticator authenticator) {
        this.setParam(opts, "proxyAuthenticator", authenticator);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions opts) {
        return (UserAuthenticator)this.getParam(opts, "proxyAuthenticator");
    }

    public void setCookies(FileSystemOptions opts, Cookie[] cookies) {
        this.setParam(opts, "cookies", cookies);
    }

    public void setFollowRedirect(FileSystemOptions opts, boolean redirect) {
        this.setParam(opts, KEY_FOLLOW_REDIRECT, redirect);
    }

    public Cookie[] getCookies(FileSystemOptions opts) {
        return (Cookie[])this.getParam(opts, "cookies");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_FOLLOW_REDIRECT, true);
    }

    public void setMaxTotalConnections(FileSystemOptions opts, int maxTotalConnections) {
        this.setParam(opts, MAX_TOTAL_CONNECTIONS, maxTotalConnections);
    }

    public int getMaxTotalConnections(FileSystemOptions opts) {
        return this.getInteger(opts, MAX_TOTAL_CONNECTIONS, 50);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions opts, int maxHostConnections) {
        this.setParam(opts, MAX_HOST_CONNECTIONS, maxHostConnections);
    }

    public int getMaxConnectionsPerHost(FileSystemOptions opts) {
        return this.getInteger(opts, MAX_HOST_CONNECTIONS, 5);
    }

    public boolean isPreemptiveAuth(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setPreemptiveAuth(FileSystemOptions opts, boolean preemptiveAuth) {
        this.setParam(opts, KEY_PREEMPTIVE_AUTHENTICATION, (Object)preemptiveAuth);
    }

    public void setConnectionTimeout(FileSystemOptions opts, int connectionTimeout) {
        this.setParam(opts, CONNECTION_TIMEOUT, connectionTimeout);
    }

    public int getConnectionTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, CONNECTION_TIMEOUT, 0);
    }

    public void setSoTimeout(FileSystemOptions opts, int soTimeout) {
        this.setParam(opts, SO_TIMEOUT, soTimeout);
    }

    public int getSoTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, SO_TIMEOUT, 0);
    }

    public void setKeepAlive(FileSystemOptions opts, boolean keepAlive) {
        this.setParam(opts, KEEP_ALIVE, (Object)keepAlive);
    }

    public boolean isKeepAlive(FileSystemOptions opts) {
        return this.getBoolean(opts, KEEP_ALIVE, true);
    }

    public void setUserAgent(FileSystemOptions opts, String userAgent) {
        this.setParam(opts, KEY_USER_AGENT, userAgent);
    }

    public String getUserAgent(FileSystemOptions opts) {
        String userAgent = (String)this.getParam(opts, KEY_USER_AGENT);
        return userAgent != null ? userAgent : DEFAULT_USER_AGENT;
    }

    public void setKeyStoreFile(FileSystemOptions opts, String keyStoreFile) {
        this.setParam(opts, KEYSTORE_FILE, keyStoreFile);
    }

    public String getKeyStoreFile(FileSystemOptions opts) {
        return (String)this.getParam(opts, KEYSTORE_FILE);
    }

    public void setKeyStorePass(FileSystemOptions opts, String keyStorePass) {
        this.setParam(opts, KEYSTORE_PASS, keyStorePass);
    }

    String getKeyStorePass(FileSystemOptions opts) {
        return (String)this.getParam(opts, KEYSTORE_PASS);
    }

    public void setKeyStoreType(FileSystemOptions opts, String keyStoreType) {
        this.setParam(opts, KEYSTORE_TYPE, keyStoreType);
    }

    public String getKeyStoreType(FileSystemOptions opts) {
        return this.getString(opts, KEYSTORE_TYPE, KeyStore.getDefaultType());
    }

    public void setHostnameVerificationEnabled(FileSystemOptions opts, boolean hostnameVerificationEnabled) {
        this.setParam(opts, HOSTNAME_VERIFICATION_ENABLED, (Object)hostnameVerificationEnabled);
    }

    public boolean isHostnameVerificationEnabled(FileSystemOptions opts) {
        return this.getBoolean(opts, HOSTNAME_VERIFICATION_ENABLED, true);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return Http4FileSystem.class;
    }
}

