/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.eclipse.equinox.p2.cudf.solver.Projector;
import org.sat4j.pb.tools.WeightedObject;

public class ParanoidOptimizationFunction
extends OptimizationFunction {
    private static final Log log = LogFactory.getLog(ParanoidOptimizationFunction.class);

    @Override
    public List<WeightedObject<Object>> createOptimizationFunction(InstallableUnit metaIu) {
        ArrayList<WeightedObject<Object>> weightedObjects = new ArrayList<WeightedObject<Object>>();
        BigInteger weight = BigInteger.valueOf(this.slice.size() + 1);
        this.removed(weightedObjects, weight, metaIu);
        this.changed(weightedObjects, BigInteger.ONE, metaIu);
        if (!weightedObjects.isEmpty()) {
            return weightedObjects;
        }
        return null;
    }

    @Override
    public String getName() {
        return "misc 2010 paranoid";
    }

    @Override
    public String printSolutionValue() {
        Projector.AbstractVariable var;
        int i;
        StringBuilder sb = new StringBuilder();
        int removed = 0;
        int changed = 0;
        ArrayList<Projector.AbstractVariable> proof = new ArrayList<Projector.AbstractVariable>();
        for (i = 0; i < this.removalVariables.size(); ++i) {
            var = (Projector.AbstractVariable)this.removalVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
            ++removed;
            proof.add(var);
        }
        for (i = 0; i < this.changeVariables.size(); ++i) {
            var = (Projector.AbstractVariable)this.changeVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
            ++changed;
            proof.add(var);
        }
        sb.append("# Paranoid criteria value: -" + removed + ", -" + changed + "\n");
        sb.append("# Proof: " + proof + "\n");
        return sb.toString();
    }
}

