/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.function;

import java.util.function.Function;
import org.nuxeo.common.function.FunctionUtils;

@FunctionalInterface
public interface ThrowableFunction<T, R, E extends Throwable> {
    public R apply(T var1) throws E;

    default public Function<T, R> toFunction() {
        return ThrowableFunction.asFunction(this);
    }

    public static <T, R, E extends Throwable> Function<T, R> asFunction(ThrowableFunction<T, R, E> throwableFunction) {
        return arg -> {
            try {
                return throwableFunction.apply(arg);
            }
            catch (Throwable t) {
                return FunctionUtils.sneakyThrow(t);
            }
        };
    }
}

