/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;

public class TextTemplate {
    private static final Log log = LogFactory.getLog(TextTemplate.class);
    private static final int MAX_RECURSION_LEVEL = 10;
    private static final String PATTERN_GROUP_DECRYPT = "decrypt";
    private static final String PATTERN_GROUP_VAR = "var";
    private static final String PATTERN_GROUP_DEFAULT = "default";
    private static final Pattern PATTERN = Pattern.compile("(?<!\\$)\\$\\{(?<decrypt>#)?(?<var>[a-zA-Z_0-9\\-\\.]+)(:=(?<default>.*))?\\}");
    private final CryptoProperties vars;
    private Properties processedVars;
    private boolean trim = false;
    private List<String> plainTextExtensions;
    private List<String> freemarkerExtensions = new ArrayList<String>();
    private Configuration freemarkerConfiguration = null;
    private Map<String, Object> freemarkerVars = null;
    private boolean keepEncryptedAsVar;

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public TextTemplate() {
        this.vars = new CryptoProperties();
    }

    public TextTemplate(Map<String, String> vars) {
        this.vars = new CryptoProperties();
        this.vars.putAll((Map<? extends Object, ? extends Object>)vars);
    }

    public TextTemplate(Properties vars) {
        this.vars = vars instanceof CryptoProperties ? (CryptoProperties)vars : new CryptoProperties(vars);
    }

    public void setVariables(Map<String, String> vars) {
        this.vars.putAll((Map<? extends Object, ? extends Object>)vars);
        this.freemarkerConfiguration = null;
    }

    public void setVariable(String name, String value) {
        this.vars.setProperty(name, value);
        this.freemarkerConfiguration = null;
    }

    public String getVariable(String name) {
        return this.vars.getProperty(name, this.keepEncryptedAsVar);
    }

    public Properties getVariables() {
        return this.vars;
    }

    protected String processString(CryptoProperties props, String text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String embeddedVar = m.group(PATTERN_GROUP_VAR);
            Object value = props.getProperty(embeddedVar, this.keepEncryptedAsVar);
            if (value == null) {
                value = m.group(PATTERN_GROUP_DEFAULT);
            }
            if (value == null) continue;
            if (this.trim) {
                value = ((String)value).trim();
            }
            if (Crypto.isEncrypted((String)value)) {
                value = this.keepEncryptedAsVar && m.group(PATTERN_GROUP_DECRYPT) == null ? "${" + embeddedVar + "}" : new String(this.vars.getCrypto().decrypt((String)value));
            }
            value = Matcher.quoteReplacement((String)value);
            m.appendReplacement(sb, (String)value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected Properties unescape(Properties props) {
        props.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> this.unescape((String)v)));
        return props;
    }

    protected String unescape(String value) {
        return value.replaceAll("\\$\\$\\{", "\\${");
    }

    private void preprocessVars() {
        this.processedVars = this.preprocessVars(this.vars);
    }

    public Properties preprocessVars(Properties unprocessedVars) {
        CryptoProperties newVars = new CryptoProperties(unprocessedVars);
        boolean doneProcessing = false;
        int recursionLevel = 0;
        while (!doneProcessing) {
            doneProcessing = true;
            for (String newVarsKey : newVars.stringPropertyNames()) {
                Object newVarsValue = newVars.getProperty(newVarsKey, this.keepEncryptedAsVar);
                if (newVarsValue == null) continue;
                if (Crypto.isEncrypted((String)newVarsValue)) {
                    assert (this.keepEncryptedAsVar);
                    newVarsValue = "${" + newVarsKey + "}";
                    newVars.put(newVarsKey, newVarsValue);
                    continue;
                }
                String replacementValue = this.processString(newVars, (String)newVarsValue);
                if (replacementValue.equals(newVarsValue)) continue;
                doneProcessing = false;
                newVars.put(newVarsKey, replacementValue);
            }
            if (doneProcessing || ++recursionLevel <= 10) continue;
            log.warn("Detected potential infinite loop when processing the following properties\n" + newVars);
            break;
        }
        return this.unescape(newVars);
    }

    public String processText(String text) {
        if (text == null) {
            return null;
        }
        boolean doneProcessing = false;
        int recursionLevel = 0;
        while (!doneProcessing) {
            doneProcessing = true;
            String processedText = this.processString(this.vars, text);
            if (!processedText.equals(text)) {
                doneProcessing = false;
                text = processedText;
            }
            if (doneProcessing || ++recursionLevel <= 10) continue;
            log.warn("Detected potential infinite loop when processing the following text\n" + text);
            break;
        }
        return this.unescape(text);
    }

    public String processText(InputStream in) throws IOException {
        String text = IOUtils.toString(in, StandardCharsets.UTF_8);
        return this.processText(text);
    }

    public void processText(InputStream is, OutputStreamWriter os) throws IOException {
        String text = IOUtils.toString(is, StandardCharsets.UTF_8);
        text = this.processText(text);
        os.write(text);
    }

    public void initFreeMarker() {
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_30);
        this.preprocessVars();
        this.freemarkerVars = new HashMap<String, Object>();
        block0: for (String key : this.processedVars.stringPropertyNames()) {
            String value = this.processedVars.getProperty(key);
            if (value.startsWith("${") && value.endsWith("}")) {
                value = this.vars.getProperty(key, false);
            }
            String[] keyparts = key.split("\\.");
            Map currentMap = this.freemarkerVars;
            Object currentString = "";
            for (int i = 0; i < keyparts.length - 1; ++i) {
                currentString = (String)currentString + ("".equals(currentString) ? "" : ".") + keyparts[i];
                if (!currentMap.containsKey(keyparts[i])) {
                    HashMap<String, Object> nextMap = new HashMap<String, Object>();
                    currentMap.put((String)keyparts[i], nextMap);
                    currentMap = nextMap;
                    continue;
                }
                if (currentMap.get(keyparts[i]) instanceof Map) {
                    currentMap = (Map)currentMap.get(keyparts[i]);
                    continue;
                }
                if (key.startsWith("java.vendor") || key.startsWith("file.encoding") || key.startsWith("audit.elasticsearch")) continue block0;
                log.warn(String.format("FreeMarker variables: ignored '%s' conflicting with '%s'", key, currentString));
                continue block0;
            }
            if (!currentMap.containsKey(keyparts[keyparts.length - 1])) {
                currentMap.put((String)keyparts[keyparts.length - 1], (Object)value);
                continue;
            }
            if (key.startsWith("java.vendor") || key.startsWith("file.encoding") || key.startsWith("audit.elasticsearch")) continue;
            Map currentValue = (Map)currentMap.get(keyparts[keyparts.length - 1]);
            log.warn(String.format("FreeMarker variables: ignored '%2$s' conflicting with '%2$s.%1$s'", currentValue.keySet(), key));
        }
    }

    public void processFreemarker(File in, File out) throws IOException, TemplateException {
        if (this.freemarkerConfiguration == null) {
            this.initFreeMarker();
        }
        this.freemarkerConfiguration.setDirectoryForTemplateLoading(in.getParentFile());
        Template nxtpl = this.freemarkerConfiguration.getTemplate(in.getName());
        try (EscapeVariableFilter writer = new EscapeVariableFilter(new FileWriter(out));){
            nxtpl.process(this.freemarkerVars, writer);
        }
    }

    public List<String> processDirectory(File in, File out) throws FileNotFoundException, IOException, TemplateException {
        ArrayList<String> newFiles = new ArrayList<String>();
        if (in.isFile()) {
            if (out.isDirectory()) {
                out = new File(out, in.getName());
            }
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            boolean processAsText = false;
            boolean processAsFreemarker = false;
            String filename = in.getName().toLowerCase();
            for (String ext : this.freemarkerExtensions) {
                if (!filename.endsWith(ext)) continue;
                processAsFreemarker = true;
                out = new File(out.getCanonicalPath().replaceAll("\\.*" + Pattern.quote(ext) + "$", ""));
                if (!filename.equals("." + ext.toLowerCase())) break;
                throw new IOException("Extension only as a filename is not allowed: " + in.getAbsolutePath());
            }
            if (!processAsFreemarker) {
                for (String ext : this.plainTextExtensions) {
                    if (!filename.endsWith(ext)) continue;
                    processAsText = true;
                    break;
                }
            }
            if (out.exists()) {
                File backup = new File(out.getPath() + ".bak");
                if (!backup.exists()) {
                    log.debug("Backup " + out);
                    FileUtils.copyFile(out, backup);
                    newFiles.add(backup.getPath());
                }
            } else {
                newFiles.add(out.getPath());
            }
            try {
                if (processAsFreemarker) {
                    log.debug("Process as FreeMarker " + in.getPath());
                    this.processFreemarker(in, out);
                }
                if (processAsText) {
                    log.debug("Process as Text " + in.getPath());
                    try (FileInputStream is = new FileInputStream(in);
                         OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8");){
                        this.processText(is, os);
                    }
                }
                log.debug("Process as copy " + in.getPath());
                FileUtils.copyFile(in, out);
            }
            catch (TemplateException | IOException e) {
                log.error("Failure on " + in.getPath());
                throw e;
            }
        } else if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdirs();
            } else if (!out.getName().equals(in.getName())) {
                out = new File(out, in.getName());
                out.mkdir();
            }
            for (File file : in.listFiles()) {
                newFiles.addAll(this.processDirectory(file, out));
            }
        }
        return newFiles;
    }

    public void setTextParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.plainTextExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken().toLowerCase();
            this.plainTextExtensions.add(extension);
        }
    }

    public void setFreemarkerParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.freemarkerExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken().toLowerCase();
            this.freemarkerExtensions.add(extension);
        }
    }

    public void setKeepEncryptedAsVar(boolean keepEncryptedAsVar) {
        if (this.keepEncryptedAsVar != keepEncryptedAsVar) {
            this.keepEncryptedAsVar = keepEncryptedAsVar;
            this.freemarkerConfiguration = null;
        }
    }

    protected static class EscapeVariableFilter
    extends FilterWriter {
        protected static final int DOLLAR_SIGN = "$".codePointAt(0);
        protected int last;

        public EscapeVariableFilter(Writer out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (b == DOLLAR_SIGN && this.last == DOLLAR_SIGN) {
                return;
            }
            this.last = b;
            super.write(b);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }
    }
}

