/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.data.IntrospectionHelper;
import org.nuxeo.connect.data.marshaling.JSONExportableField;
import org.nuxeo.connect.data.marshaling.JSONImportMethod;

public abstract class AbstractJSONSerializableData {
    @JSONExportableField
    protected String errorMessage;

    public boolean isError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String serializeAsJSON() {
        return this.asJSON().toString();
    }

    public JSONObject asJSONold() {
        return new JSONObject(this);
    }

    public JSONObject asJSON() {
        return new JSONObject(IntrospectionHelper.getDataToSerialize(this));
    }

    protected static Object doLoadFromJSON(JSONObject data, Class<?> klass, Object instance) throws JSONException {
        if (klass.getSuperclass() != null) {
            instance = AbstractJSONSerializableData.doLoadFromJSON(data, klass.getSuperclass(), instance);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Method method : instance.getClass().getDeclaredMethods()) {
            if (method.getAnnotation(JSONImportMethod.class) == null) continue;
            try {
                String name = method.getAnnotation(JSONImportMethod.class).name();
                fieldNames.add(name);
                Object value = data.get(name);
                method.invoke(instance, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : instance.getClass().getDeclaredFields()) {
            if (((Field)accessibleObject).getAnnotation(JSONExportableField.class) == null || fieldNames.contains(((Field)accessibleObject).getName())) continue;
            try {
                ((Field)accessibleObject).set(instance, data.get(((Field)accessibleObject).getName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public static <T> T loadFromJSON(Class<T> targetClass, JSONObject data) throws JSONException {
        try {
            return targetClass.cast(AbstractJSONSerializableData.doLoadFromJSON(data, targetClass, targetClass.newInstance()));
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    public static <T> T loadFromJSON(Class<T> targetClass, String dataStr) throws JSONException {
        JSONObject data = new JSONObject(dataStr);
        return AbstractJSONSerializableData.loadFromJSON(targetClass, data);
    }
}

