/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.platform;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.connect.platform.PlatformVersion;

public class PlatformVersionRange {
    private final PlatformVersion lowerBound;
    private final boolean lowerBoundInclusive;
    private final PlatformVersion upperBound;
    private final boolean upperBoundInclusive;
    public static final PlatformVersionRange EVERYTHING = new PlatformVersionRange(null, false, null, false);

    public PlatformVersionRange(PlatformVersion lowerBound, boolean lowerBoundInclusive, PlatformVersion upperBound, boolean upperBoundInclusive) {
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBoundInclusive;
    }

    public PlatformVersion getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public PlatformVersion getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    public static PlatformVersionRange fromRangeSpec(String rangeSpec) {
        if (StringUtils.isBlank(rangeSpec)) {
            throw new IllegalArgumentException("Range cannot be blank");
        }
        rangeSpec = rangeSpec.trim();
        boolean lowerBoundInclusive = rangeSpec.startsWith("[");
        boolean upperBoundInclusive = rangeSpec.endsWith("]");
        if (!rangeSpec.contains(",")) {
            String process;
            if (lowerBoundInclusive && upperBoundInclusive) {
                process = rangeSpec.substring(1, rangeSpec.length() - 1).trim();
            } else {
                if (lowerBoundInclusive || upperBoundInclusive || rangeSpec.startsWith("(") || rangeSpec.endsWith(")")) {
                    throw new IllegalArgumentException("Single version can only have inclusive boundaries ('[x.y.z]'): " + rangeSpec);
                }
                process = rangeSpec.trim();
                upperBoundInclusive = true;
                lowerBoundInclusive = true;
            }
            PlatformVersion version = new PlatformVersion(process);
            return new PlatformVersionRange(version, lowerBoundInclusive, version, upperBoundInclusive);
        }
        if (!lowerBoundInclusive && !rangeSpec.startsWith("(")) {
            throw new IllegalArgumentException("Range should start with '[' or '(': " + rangeSpec);
        }
        if (!upperBoundInclusive && !rangeSpec.endsWith(")")) {
            throw new IllegalArgumentException("Range should end with ']' or ')': " + rangeSpec);
        }
        String process = rangeSpec.substring(1, rangeSpec.length() - 1).trim();
        int index = process.indexOf(44);
        String lowerBound = process.substring(0, index).trim();
        String upperBound = process.substring(index + 1).trim();
        PlatformVersion lowerVersion = null;
        if (lowerBound.length() > 0) {
            lowerVersion = new PlatformVersion(lowerBound);
        }
        PlatformVersion upperVersion = null;
        if (upperBound.length() > 0) {
            upperVersion = new PlatformVersion(upperBound);
        }
        if (upperVersion != null && lowerVersion != null) {
            if (!(lowerBoundInclusive && upperBoundInclusive || !upperVersion.equals(lowerVersion))) {
                throw new IllegalArgumentException("Range cannot have identical boundaries with exclusions: " + rangeSpec);
            }
            if (upperVersion.compareTo(lowerVersion) < 0) {
                throw new IllegalArgumentException("Range defies version ordering: " + rangeSpec);
            }
        }
        return new PlatformVersionRange(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
    }

    public boolean containsVersion(PlatformVersion version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo(version);
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo(version);
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 13;
        result = this.lowerBound == null ? ++result : (result += this.lowerBound.hashCode());
        result *= this.lowerBoundInclusive ? 1 : 2;
        result = this.upperBound == null ? (result -= 3) : (result -= this.upperBound.hashCode());
        return result *= this.upperBoundInclusive ? 2 : 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformVersionRange)) {
            return false;
        }
        PlatformVersionRange restriction = (PlatformVersionRange)other;
        if (this.lowerBound != null ? !this.lowerBound.equals(restriction.lowerBound) : restriction.lowerBound != null) {
            return false;
        }
        if (this.lowerBoundInclusive != restriction.lowerBoundInclusive) {
            return false;
        }
        if (this.upperBound != null ? !this.upperBound.equals(restriction.upperBound) : restriction.upperBound != null) {
            return false;
        }
        return this.upperBoundInclusive == restriction.upperBoundInclusive;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.isLowerBoundInclusive() ? (char)'[' : '(');
        if (this.getLowerBound() != null) {
            buf.append(this.getLowerBound().toString());
        }
        buf.append(',');
        if (this.getUpperBound() != null) {
            buf.append(this.getUpperBound().toString());
        }
        buf.append(this.isUpperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

