/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.AbstractTask;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.task.standalone.commands.CompositeCommand;
import org.nuxeo.connect.update.task.standalone.commands.DeployPlaceholder;
import org.nuxeo.connect.update.task.update.JarUtils;
import org.nuxeo.connect.update.task.update.Rollback;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.connect.update.task.update.VersionAlreadyExistException;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class Update
extends AbstractCommand {
    protected static final Log log = LogFactory.getLog(Update.class);
    public static final String ID = "update";
    protected File file;
    protected File todir;
    protected boolean removeOnExit;
    protected boolean allowDowngrade = false;
    protected boolean upgradeOnly = false;

    protected Update(String id) {
        super(id);
    }

    public Update() {
        this(ID);
    }

    @Override
    public void initialize(Element element) throws PackageException {
        super.initialize(element);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        File dir = null;
        String v = element.getAttribute("dir");
        if (v.length() > 0) {
            dir = new File(v);
        }
        if ((v = element.getAttribute("file")).length() > 0) {
            this.file = dir != null ? new File(dir, v) : new File(v);
            this.guardVars.put("file", this.file);
        } else {
            this.file = dir;
            this.guardVars.put("dir", dir);
        }
        v = element.getAttribute("todir");
        if (v.length() > 0) {
            this.todir = new File(v);
            this.guardVars.put("todir", this.todir);
        }
        if ((v = element.getAttribute("removeOnExit")).length() > 0) {
            this.removeOnExit = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("allowDowngrade")).length() > 0) {
            this.allowDowngrade = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("upgradeOnly")).length() > 0) {
            this.upgradeOnly = Boolean.parseBoolean(v);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        if (this.todir != null) {
            writer.attr("todir", this.todir.getAbsolutePath());
        }
        if (this.removeOnExit) {
            writer.attr("removeOnExit", "true");
        }
        if (this.allowDowngrade) {
            writer.attr("allowDowngrade", "true");
        }
        if (this.upgradeOnly) {
            writer.attr("upgradeOnly", "true");
        }
        writer.end();
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.file == null || this.todir == null) {
            status.addError("Cannot execute command in installer. Invalid update syntax: file or todir was not specified.");
            return;
        }
        if (this.todir.isFile()) {
            status.addError("Cannot execute command in installer. Invalid update command: todir should be a directory!");
        }
        if (this.file.isFile()) {
            JarUtils.Match<String> match = JarUtils.findJarVersion(this.file.getName());
            if (match == null) {
                status.addError("Cannot execute command in installer. Cannot use 'update' command for non versioned files!. File name must contain a version: " + this.file.getName());
            }
        } else if (!this.file.isDirectory()) {
            status.addWarning("Ignored command in installer. Source file not found! " + this.file.getName());
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        AbstractCommand rollback;
        if (!this.file.exists()) {
            log.warn("Can't update using " + this.file + ". File is missing.");
            return null;
        }
        UpdateManager mgr = ((AbstractTask)task).getUpdateManager();
        Command deploy = this.getDeployCommand(mgr, rollback = this.file.isDirectory() ? this.updateDirectory(task, this.file, mgr) : this.updateFile(task, this.file, mgr));
        if (deploy != null) {
            deploy.run(task, prefs);
        }
        return rollback;
    }

    protected CompositeCommand updateDirectory(Task task, File dir, UpdateManager mgr) throws PackageException {
        CompositeCommand cmd = new CompositeCommand();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File fileInDir : files) {
                cmd.addCommand(this.updateFile(task, fileInDir, mgr));
            }
        }
        return cmd;
    }

    protected Rollback updateFile(Task task, File fileToUpdate, UpdateManager mgr) throws PackageException {
        UpdateOptions opt = UpdateOptions.newInstance(task.getPackage().getId(), fileToUpdate, this.todir);
        if (opt == null) {
            return null;
        }
        opt.setAllowDowngrade(this.allowDowngrade);
        opt.setUpgradeOnly(this.upgradeOnly);
        opt.deleteOnExit = this.removeOnExit;
        try {
            RollbackOptions r = mgr.update(opt);
            return new Rollback(r);
        }
        catch (VersionAlreadyExistException e) {
            log.error(e, e);
            return null;
        }
    }

    protected Command getDeployCommand(UpdateManager updateManager, Command rollbackCommand) {
        return new DeployPlaceholder(this.file);
    }

    public File getFile() {
        return this.file;
    }
}

