/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.info.CommandInfo;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="commands")
public class CommandSetInfo {
    static final Log log = LogFactory.getLog(CommandSetInfo.class);
    @XmlElement(name="command")
    public List<CommandInfo> commands = new ArrayList<CommandInfo>();

    public CommandInfo newCommandInfo(String cmdType) {
        CommandInfo cmdInfo = new CommandInfo(cmdType);
        this.commands.add(cmdInfo);
        return cmdInfo;
    }

    public void log() {
        this.log(false);
    }

    public void log(boolean debug) {
        if (this.commands.isEmpty()) {
            return;
        }
        if (debug) {
            log.debug("\nCommands debug dump:");
        } else {
            log.error("\nFailed commands:");
        }
        for (CommandInfo commandInfo : this.commands) {
            commandInfo.log(debug);
        }
    }
}

