/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.common.xmap.registry.SingleRegistry;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.Descriptor;
import org.nuxeo.runtime.model.DescriptorRegistry;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;

public class DefaultComponent
implements Component,
Adaptable {
    protected String name;
    protected Long lastModified;
    private DescriptorRegistry registry;

    @Override
    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public void activate(ComponentContext context) {
        this.registry = ((ComponentManagerImpl)context.getRuntimeContext().getRuntime().getComponentManager()).getDescriptors();
        this.setModifiedNow();
    }

    @Override
    public void deactivate(ComponentContext context) {
        if (this.getRegistry() != null) {
            this.getRegistry().clear();
        }
        this.setModifiedNow();
    }

    protected void addRuntimeMessage(RuntimeMessage.Level level, String message) {
        this.addRuntimeMessage(level, message, RuntimeMessage.Source.COMPONENT, this.name);
    }

    protected void addRuntimeMessage(RuntimeMessage.Level level, String message, RuntimeMessage.Source source, String sourceComponent) {
        Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(level, message, source, sourceComponent));
    }

    @Override
    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            this.registerContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
        this.setModifiedNow();
    }

    @Override
    public void unregisterExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            this.unregisterContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
        this.setModifiedNow();
    }

    @Deprecated(since="11.5")
    public void registerContribution(Object contribution, String xp, ComponentInstance component) {
        if (contribution instanceof Descriptor) {
            this.register(xp, (Descriptor)contribution);
        }
    }

    @Deprecated(since="11.5")
    public void unregisterContribution(Object contribution, String xp, ComponentInstance component) {
        if (contribution instanceof Descriptor) {
            this.unregister(xp, (Descriptor)contribution);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return adapter.cast(this);
    }

    @Override
    public void start(ComponentContext context) {
        this.applicationStarted(context);
    }

    @Override
    public void stop(ComponentContext context) throws InterruptedException {
    }

    protected void setModifiedNow() {
        this.setLastModified(System.currentTimeMillis());
    }

    @Override
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    @Deprecated(since="11.5")
    protected DescriptorRegistry getRegistry() {
        return this.registry;
    }

    @Deprecated(since="11.5")
    protected boolean register(String xp, Descriptor descriptor) {
        return this.getRegistry().register(this.name, xp, descriptor);
    }

    @Deprecated(since="11.5")
    protected boolean unregister(String xp, Descriptor descriptor) {
        return this.getRegistry().unregister(this.name, xp, descriptor);
    }

    @Deprecated(since="11.5")
    protected <T extends Descriptor> T getDescriptor(String xp, String id) {
        return this.getRegistry().getDescriptor(this.name, xp, id);
    }

    @Deprecated(since="11.5")
    protected <T extends Descriptor> List<T> getDescriptors(String xp) {
        return this.getRegistry().getDescriptors(this.name, xp);
    }

    protected <T extends Registry> T getExtensionPointRegistry(String point) {
        return (T)((Registry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry(this.name, point).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", this.name, point))));
    }

    protected <T> Optional<T> getRegistryContribution(String point) {
        SingleRegistry registry = (SingleRegistry)this.getExtensionPointRegistry(point);
        return registry.getContribution();
    }

    protected <T> Optional<T> getRegistryContribution(String point, String id) {
        MapRegistry registry = (MapRegistry)this.getExtensionPointRegistry(point);
        return registry.getContribution(id);
    }

    protected <T> List<T> getRegistryContributions(String point) {
        MapRegistry registry = (MapRegistry)this.getExtensionPointRegistry(point);
        return registry.getContributionValues();
    }
}

