/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverStats;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBSolver
extends Solver<PBDataStructureFactory>
implements IPBSolver {
    private ObjectiveFunction objf;
    private static final long serialVersionUID = 1L;
    protected PBSolverStats stats = new PBSolverStats();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.core.PBSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, IOrder order, RestartStrategy restarter) {
        super(learner, dsf, order, restarter);
        this.initStats(this.stats);
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order, RestartStrategy restarter) {
        super(learner, dsf, params, order, restarter);
        this.initStats(this.stats);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt literals, IVec<BigInteger> coeffs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        if (!$assertionsDisabled && vlits.size() != literals.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && literals.size() != coeffs.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, moreThan, degree));
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.objf = obj;
        IOrder order = this.getOrder();
        if (order instanceof IOrderObjective) {
            ((IOrderObjective)order).setObjectiveFunction(obj);
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objf;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        Vec<BigInteger> bcoeffs = new Vec<BigInteger>(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push(BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addAtMost(literals, bcoeffs, BigInteger.valueOf(degree));
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        if (!$assertionsDisabled && vlits.size() != literals.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && literals.size() != coeffs.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, false, degree));
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        Vec<BigInteger> bcoeffs = new Vec<BigInteger>(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push(BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addAtLeast(literals, bcoeffs, BigInteger.valueOf(degree));
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        if (!$assertionsDisabled && vlits.size() != literals.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && literals.size() != coeffs.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, true, degree));
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        Vec<BigInteger> bcoeffs = new Vec<BigInteger>(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push(BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addExactly(literals, bcoeffs, BigInteger.valueOf(weight));
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        if (!$assertionsDisabled && vlits.size() != literals.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && literals.size() != coeffs.size()) {
            throw new AssertionError();
        }
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, false, weight)));
        group.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, true, weight)));
        return group;
    }
}

