/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.consumers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.consumers.OAuthConsumerRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthConsumerRegistryImpl
extends DefaultComponent
implements OAuthConsumerRegistry {
    protected static final Log log = LogFactory.getLog(OAuthConsumerRegistryImpl.class);
    public static final String DIRECTORY_NAME = "oauthConsumers";

    @Override
    public NuxeoOAuthConsumer getConsumer(String consumerKey, String keyType) {
        try {
            NuxeoOAuthConsumer consumer = this.getEntry(consumerKey, keyType);
            return consumer;
        }
        catch (DirectoryException e) {
            log.error((Object)("Unable to read consumer " + consumerKey + " from Directory backend"), (Throwable)e);
            return null;
        }
    }

    @Override
    public NuxeoOAuthConsumer getConsumer(String consumerKey) {
        return this.getConsumer(consumerKey, null);
    }

    protected NuxeoOAuthConsumer getEntry(String consumerKey, String keyType) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (NuxeoOAuthConsumer)((Object)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModel entry = session.getEntry(consumerKey);
                if (entry == null) {
                    NuxeoOAuthConsumer nuxeoOAuthConsumer = null;
                    return nuxeoOAuthConsumer;
                }
                NuxeoOAuthConsumer nuxeoOAuthConsumer = NuxeoOAuthConsumer.createFromDirectoryEntry(entry, keyType);
                return nuxeoOAuthConsumer;
            }
        }));
    }

    @Override
    public NuxeoOAuthConsumer storeConsumer(NuxeoOAuthConsumer consumer) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (NuxeoOAuthConsumer)((Object)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModel entry = session.createEntry(Collections.singletonMap("consumerKey", consumer.consumerKey));
                consumer.asDocumentModel(entry);
                session.updateEntry(entry);
                NuxeoOAuthConsumer nuxeoOAuthConsumer = NuxeoOAuthConsumer.createFromDirectoryEntry(entry, null);
                return nuxeoOAuthConsumer;
            }
        }));
    }

    @Override
    public void deleteConsumer(String consumerKey) {
        Framework.doPrivileged(() -> {
            try {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                try (Session session = ds.open(DIRECTORY_NAME);){
                    session.deleteEntry(consumerKey);
                }
            }
            catch (DirectoryException e) {
                log.error((Object)("Unable to delete consumer " + consumerKey), (Throwable)e);
            }
        });
    }

    @Override
    public List<NuxeoOAuthConsumer> listConsumers() {
        return (List)Framework.doPrivileged(() -> {
            ArrayList<NuxeoOAuthConsumer> arrayList;
            block9: {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                Session session = ds.open(DIRECTORY_NAME);
                try {
                    DocumentModelList entries = session.query(Collections.emptyMap());
                    ArrayList<NuxeoOAuthConsumer> result = new ArrayList<NuxeoOAuthConsumer>();
                    for (DocumentModel entry : entries) {
                        result.add(NuxeoOAuthConsumer.createFromDirectoryEntry(entry, null));
                    }
                    arrayList = result;
                    if (session == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryException e) {
                        log.error((Object)"Error while fetching consumer directory", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                session.close();
            }
            return arrayList;
        });
    }
}

