/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentStringBlobHolder;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.HtmlGuesser;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterManager;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDiffer;
import org.nuxeo.runtime.api.Framework;

public final class ContentDiffHelper {
    public static final String CONTENT_DIFF_FANCYBOX_VIEW = "content_diff_fancybox";
    public static final String LABEL_URL_PARAM_NAME = "label";
    public static final String XPATH_URL_PARAM_NAME = "xPath";
    public static final String CONVERSION_TYPE_URL_PARAM_NAME = "conversionType";
    public static final String LOCALE_URL_PARAM_NAME = "locale";
    public static final String CONTENT_DIFF_URL_PREFIX = "restAPI/contentDiff/";
    public static final String DEFAULT_XPATH = "default";

    private ContentDiffHelper() {
    }

    public static String getContentDiffURL(DocumentModel leftDoc, DocumentModel rightDoc, String conversionType, String locale) {
        return ContentDiffHelper.getContentDiffURL(leftDoc.getRepositoryName(), leftDoc, rightDoc, DEFAULT_XPATH, conversionType, locale);
    }

    public static String getContentDiffURL(DocumentModel leftDoc, DocumentModel rightDoc, String propertyXPath, String conversionType, String locale) {
        return ContentDiffHelper.getContentDiffURL(leftDoc.getRepositoryName(), leftDoc, rightDoc, propertyXPath, conversionType, locale);
    }

    public static String getContentDiffURL(String repositoryName, DocumentModel leftDoc, DocumentModel rightDoc, String propertyXPath, String conversionType, String locale) {
        if (propertyXPath == null) {
            propertyXPath = DEFAULT_XPATH;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CONTENT_DIFF_URL_PREFIX);
        sb.append(repositoryName);
        sb.append("/");
        sb.append(leftDoc.getId());
        sb.append("/");
        sb.append(rightDoc.getId());
        sb.append("/");
        sb.append(propertyXPath);
        sb.append("/");
        boolean isQueryParam = false;
        if (!StringUtils.isEmpty((CharSequence)conversionType)) {
            sb.append("?");
            sb.append(CONVERSION_TYPE_URL_PARAM_NAME);
            sb.append("=");
            sb.append(conversionType);
            isQueryParam = true;
        }
        if (!StringUtils.isEmpty((CharSequence)locale)) {
            sb.append(isQueryParam ? "&" : "?");
            sb.append(LOCALE_URL_PARAM_NAME);
            sb.append("=");
            sb.append(locale);
            isQueryParam = true;
        }
        return sb.toString();
    }

    public static boolean isDisplayHtmlConversion(Serializable property) {
        if (ContentDiffHelper.isContentProperty(property)) {
            Blob blob = (Blob)property;
            String mimeType = blob.getMimeType();
            if (((ContentDiffAdapterManager)Framework.getService(ContentDiffAdapterManager.class)).getHtmlConversionBlacklistedMimeTypes().contains(mimeType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isDisplayTextConversion(Serializable property) {
        if (!ContentDiffHelper.isContentProperty(property)) {
            return false;
        }
        Blob blob = (Blob)property;
        String mimeType = blob.getMimeType();
        ContentDiffAdapterManager contentDiffAdapterManager = (ContentDiffAdapterManager)Framework.getService(ContentDiffAdapterManager.class);
        MimeTypeContentDiffer mimeTypeContentDiffer = contentDiffAdapterManager.getContentDiffer(mimeType);
        return mimeTypeContentDiffer == null;
    }

    public static boolean isContentProperty(Serializable property) {
        return property instanceof Blob;
    }

    @Deprecated
    protected static List<String> getHtmlConversionBlackListedMimeTypes() {
        ArrayList<String> blackListedMimeTypes = new ArrayList<String>();
        blackListedMimeTypes.add("application/pdf");
        blackListedMimeTypes.add("application/vnd.ms-excel");
        blackListedMimeTypes.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        blackListedMimeTypes.add("application/vnd.sun.xml.calc");
        blackListedMimeTypes.add("application/vnd.sun.xml.calc.template");
        blackListedMimeTypes.add("application/vnd.oasis.opendocument.spreadsheet");
        blackListedMimeTypes.add("application/vnd.oasis.opendocument.spreadsheet-template");
        blackListedMimeTypes.add("application/vnd.ms-powerpoint");
        blackListedMimeTypes.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        blackListedMimeTypes.add("application/vnd.sun.xml.impress");
        blackListedMimeTypes.add("application/vnd.sun.xml.impress.template");
        blackListedMimeTypes.add("application/vnd.oasis.opendocument.presentation");
        blackListedMimeTypes.add("application/vnd.oasis.opendocument.presentation-template");
        return blackListedMimeTypes;
    }

    public static BlobHolder getBlobHolder(DocumentModel doc, String xPath) throws ContentDiffException {
        Serializable prop = doc.getPropertyValue(xPath);
        if (prop instanceof Blob) {
            return new DocumentBlobHolder(doc, xPath);
        }
        if (prop instanceof String) {
            String mimeType = "text/plain";
            if ("note:note".equals(xPath)) {
                mimeType = (String)((Object)doc.getPropertyValue("note:mime_type"));
            } else if (HtmlGuesser.isHtml((String)((Object)prop))) {
                mimeType = "text/html";
            }
            return new DocumentStringBlobHolder(doc, xPath, mimeType);
        }
        throw new ContentDiffException(String.format("Cannot get BlobHolder for doc '%s' and xpath '%s'.", doc.getTitle(), xPath));
    }
}

