/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.adapter;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDiffer;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.outerj.daisy.diff.HtmlCleaner;
import org.outerj.daisy.diff.XslFilter;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.outerj.daisy.diff.output.DiffOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlContentDiffer
implements MimeTypeContentDiffer {
    private static final Log LOGGER = LogFactory.getLog(HtmlContentDiffer.class);
    protected static final String NUXEO_DEFAULT_CONTEXT_PATH = "/nuxeo";

    @Override
    public List<Blob> getContentDiff(DocumentModel leftDoc, DocumentModel rightDoc, String xpath, Locale locale) throws ContentDiffException {
        BlobHolder rightBlobHolder;
        BlobHolder leftBlobHolder;
        if (StringUtils.isBlank((CharSequence)xpath) || "default".equals(xpath)) {
            leftBlobHolder = (BlobHolder)leftDoc.getAdapter(BlobHolder.class);
            rightBlobHolder = (BlobHolder)rightDoc.getAdapter(BlobHolder.class);
        } else {
            leftBlobHolder = ContentDiffHelper.getBlobHolder(leftDoc, xpath);
            rightBlobHolder = ContentDiffHelper.getBlobHolder(rightDoc, xpath);
        }
        if (leftBlobHolder == null || rightBlobHolder == null) {
            throw new ContentDiffException("Can not make a content diff of documents without a blob");
        }
        Blob leftBlob = leftBlobHolder.getBlob();
        Blob rightBlob = rightBlobHolder.getBlob();
        if (leftBlob == null || rightBlob == null) {
            throw new ContentDiffException("Can not make a content diff of documents without a blob");
        }
        return this.getContentDiff(leftBlob, rightBlob, locale);
    }

    @Override
    public List<Blob> getContentDiff(Blob leftBlob, Blob rightBlob, Locale locale) throws ContentDiffException {
        try {
            ContentHandler postProcess;
            ArrayList<Blob> blobResults = new ArrayList<Blob>();
            StringWriter sw = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXTransformerFactory stf = (SAXTransformerFactory)factory;
            TransformerHandler transformHandler = stf.newTransformerHandler();
            transformHandler.setResult(new StreamResult(sw));
            XslFilter htmlHeaderXslFilter = new XslFilter();
            String htmlHeaderXslPath = String.format("xslfilter/htmldiffheader_%s.xsl", locale.getLanguage());
            try {
                postProcess = htmlHeaderXslFilter.xsl((ContentHandler)transformHandler, htmlHeaderXslPath);
            }
            catch (IllegalStateException ise) {
                LOGGER.error((Object)String.format("Could not find the HTML diff header xsl file '%s', falling back on the default one.", htmlHeaderXslPath), (Throwable)ise);
                postProcess = htmlHeaderXslFilter.xsl((ContentHandler)transformHandler, "xslfilter/htmldiffheader.xsl");
            }
            String prefix = "diff";
            HtmlCleaner cleaner = new HtmlCleaner();
            InputSource leftIS = new InputSource(leftBlob.getStream());
            InputSource rightIS = new InputSource(rightBlob.getStream());
            DomTreeBuilder leftHandler = new DomTreeBuilder();
            cleaner.cleanAndParse(leftIS, (ContentHandler)leftHandler);
            TextNodeComparator leftComparator = new TextNodeComparator((DomTree)leftHandler, locale);
            DomTreeBuilder rightHandler = new DomTreeBuilder();
            cleaner.cleanAndParse(rightIS, (ContentHandler)rightHandler);
            TextNodeComparator rightComparator = new TextNodeComparator((DomTree)rightHandler, locale);
            postProcess.startDocument();
            postProcess.startElement("", "diffreport", "diffreport", new AttributesImpl());
            postProcess.startElement("", "diff", "diff", new AttributesImpl());
            HtmlSaxDiffOutput output = new HtmlSaxDiffOutput(postProcess, prefix);
            HTMLDiffer differ = new HTMLDiffer((DiffOutput)output);
            differ.diff(leftComparator, rightComparator);
            postProcess.endElement("", "diff", "diff");
            postProcess.endElement("", "diffreport", "diffreport");
            postProcess.endDocument();
            String stringBlob = sw.toString().replaceAll(NUXEO_DEFAULT_CONTEXT_PATH, VirtualHostHelper.getContextPathProperty());
            Blob mainBlob = Blobs.createBlob((String)stringBlob);
            sw.close();
            mainBlob.setFilename("contentDiff.html");
            mainBlob.setMimeType("text/html");
            blobResults.add(mainBlob);
            return blobResults;
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new ContentDiffException(e);
        }
    }
}

