/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.converters;

import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.diff.content.converters.AbstractContentDiffConverter;
import org.nuxeo.runtime.api.Framework;

public class ContentDiffHtmlConverter
extends AbstractContentDiffConverter {
    private static final Logger log = LogManager.getLogger(ContentDiffHtmlConverter.class);
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String ANY_2_HTML_CONVERTER_NAME = "any2html";
    private static final String OFFICE_2_HTML_CONVERTER_NAME = "office2html";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob blob = blobHolder.getBlob();
        if (blob == null) {
            log.warn("Trying to convert a blob holder that has a null blob. Nothing to do, returning the blob holder.");
            return blobHolder;
        }
        String mimeType = blob.getMimeType();
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        String converterName = cs.getConverterName(mimeType, HTML_MIME_TYPE, false);
        if (ANY_2_HTML_CONVERTER_NAME.equals(converterName) && !"application/pdf".equals(mimeType)) {
            converterName = OFFICE_2_HTML_CONVERTER_NAME;
        }
        if (converterName == null) {
            throw new ConverterNotRegistered(String.format("for sourceMimeType = %s, destinationMimeType = %s", mimeType, HTML_MIME_TYPE));
        }
        return this.convert(converterName, blobHolder, parameters);
    }
}

