/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.diff.content.ContentDiffAdapter;
import org.nuxeo.ecm.diff.content.ContentDiffRepositoryInit;
import org.nuxeo.ecm.diff.content.adapter.base.ContentDiffConversionType;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(init=ContentDiffRepositoryInit.class)
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.convert:OSGI-INF/convert-service-contrib.xml"}), @Deploy(value={"org.nuxeo.diff.content"})})
public class TestContentDiffAdapter {
    @Inject
    protected CoreSession session;

    @Test
    public void testPlainTextFilesContentDiff() {
        DocumentModel leftDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getLeftPlainTextDocPath()));
        DocumentModel rightDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getRightPlainTextDocPath()));
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)leftDoc.getAdapter(ContentDiffAdapter.class);
        Assert.assertNotNull((Object)contentDiffAdapter);
        List contentDiffBlobs = contentDiffAdapter.getFileContentDiffBlobs(rightDoc, null, Locale.ENGLISH);
        Assert.assertNotNull((Object)contentDiffBlobs);
        Assert.assertEquals((long)1L, (long)contentDiffBlobs.size());
        Blob contentDiffBlob = (Blob)contentDiffBlobs.get(0);
        Assert.assertNotNull((Object)contentDiffBlob);
        this.checkContentDiff("plain_text_content_diff.html", contentDiffBlob);
    }

    @Test
    public void testHTMLFilesContentDiff() {
        DocumentModel leftDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getLeftHTMLDocPath()));
        DocumentModel rightDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getRightHTMLDocPath()));
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)leftDoc.getAdapter(ContentDiffAdapter.class);
        Assert.assertNotNull((Object)contentDiffAdapter);
        List contentDiffBlobs = contentDiffAdapter.getFileContentDiffBlobs(rightDoc, ContentDiffConversionType.html, Locale.ENGLISH);
        Assert.assertNotNull((Object)contentDiffBlobs);
        Assert.assertEquals((long)1L, (long)contentDiffBlobs.size());
        Blob contentDiffBlob = (Blob)contentDiffBlobs.get(0);
        Assert.assertNotNull((Object)contentDiffBlob);
        this.checkContentDiff("html_content_diff.html", contentDiffBlob);
    }

    @Test
    public void testJSONFilesContentDiff() {
        DocumentModel leftDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getLeftJSONDocPath()));
        DocumentModel rightDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getRightJSONDocPath()));
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)leftDoc.getAdapter(ContentDiffAdapter.class);
        Assert.assertNotNull((Object)contentDiffAdapter);
        List contentDiffBlobs = contentDiffAdapter.getFileContentDiffBlobs(rightDoc, ContentDiffConversionType.html, Locale.ENGLISH);
        Assert.assertNotNull((Object)contentDiffBlobs);
        Assert.assertEquals((long)1L, (long)contentDiffBlobs.size());
        Blob contentDiffBlob = (Blob)contentDiffBlobs.get(0);
        Assert.assertNotNull((Object)contentDiffBlob);
        this.checkContentDiff("json_content_diff.html", contentDiffBlob);
    }

    @Test
    public void testOfficeFilesTextConversionContentDiff() {
        DocumentModel leftDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getLeftOfficeDocPath()));
        DocumentModel rightDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getRightOfficeDocPath()));
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)leftDoc.getAdapter(ContentDiffAdapter.class);
        Assert.assertNotNull((Object)contentDiffAdapter);
        List contentDiffBlobs = contentDiffAdapter.getFileContentDiffBlobs(rightDoc, ContentDiffConversionType.text, Locale.ENGLISH);
        Assert.assertNotNull((Object)contentDiffBlobs);
        Assert.assertEquals((long)1L, (long)contentDiffBlobs.size());
        Blob contentDiffBlob = (Blob)contentDiffBlobs.get(0);
        Assert.assertNotNull((Object)contentDiffBlob);
        this.checkContentDiff("office_text_conversion_content_diff.html", contentDiffBlob);
    }

    @Test
    public void testImageFilesContentDiff() {
        DocumentModel leftDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getLeftImageDocPath()));
        DocumentModel rightDoc = this.session.getDocument((DocumentRef)new PathRef(ContentDiffRepositoryInit.getRightImageDocPath()));
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)leftDoc.getAdapter(ContentDiffAdapter.class);
        Assert.assertNotNull((Object)contentDiffAdapter);
        try {
            contentDiffAdapter.getFileContentDiffBlobs(rightDoc, ContentDiffConversionType.text, Locale.ENGLISH);
            Assert.fail((String)"No png2text converter is registered, call should have thrown a ConverterNotRegistered exception.");
        }
        catch (ConverterNotRegistered cnr) {
            Assert.assertEquals((Object)"Converter for sourceMimeType = image/png, destinationMimeType = text/plain is not registered", (Object)cnr.getMessage());
        }
        try {
            contentDiffAdapter.getFileContentDiffBlobs(rightDoc, ContentDiffConversionType.html, Locale.ENGLISH);
            Assert.fail((String)"No png2html converter is registered, call should have thrown a ConverterNotRegistered exception.");
        }
        catch (ConverterNotRegistered cnr) {
            Assert.assertEquals((Object)"Converter for sourceMimeType = image/png, destinationMimeType = text/html is not registered", (Object)cnr.getMessage());
        }
    }

    protected void checkContentDiff(String expectedBlobPath, Blob contentDiffBlob) {
        try {
            Blob expectedblob = Blobs.createBlob((File)FileUtils.getResourceFileFromContext((String)expectedBlobPath));
            String expected = expectedblob.getString();
            String actual = contentDiffBlob.getString();
            if (SystemUtils.IS_OS_WINDOWS) {
                expected = expected.trim();
                expected = expected.replace("\n", "");
                expected = expected.replace("\r", "");
                actual = actual.trim();
                actual = actual.replace("\n", "");
                actual = actual.replace("\r", "");
            }
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (IOException ioe) {
            Assert.fail((String)"Error while getting content diff blob strings");
        }
    }
}

