/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.diff.content.ContentDiffRepositoryInit;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterManager;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@RepositoryConfig(init=ContentDiffRepositoryInit.class)
@Deploy(value={"org.nuxeo.diff.content"})
public class TestContentDiffAdapterManager {
    @Inject
    protected ContentDiffAdapterManager contentDiffAdapterManager;

    @Test
    public void testDefaultHtmlConversionBlacklistedMimeTypes() {
        Set mimeTypes = this.contentDiffAdapterManager.getHtmlConversionBlacklistedMimeTypes();
        Assert.assertEquals((long)13L, (long)mimeTypes.size());
        Assert.assertTrue((boolean)mimeTypes.contains("application/pdf"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/vnd.ms-excel"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/vnd.ms-powerpoint"));
    }

    @Test
    @Deploy(value={"org.nuxeo.diff.content:OSGI-INF/test-blacklisted-mime-types-contrib.xml"})
    public void testCustomHtmlConversionBlacklistedMimeTypes() {
        Set mimeTypes = this.contentDiffAdapterManager.getHtmlConversionBlacklistedMimeTypes();
        Assert.assertEquals((long)12L, (long)mimeTypes.size());
        Assert.assertTrue((boolean)mimeTypes.contains("application/vnd.ms-excel"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/msword"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/rtf"));
        Assert.assertFalse((boolean)mimeTypes.contains("application/pdf"));
        Assert.assertFalse((boolean)mimeTypes.contains("application/vnd.ms-powerpoint"));
        Assert.assertFalse((boolean)mimeTypes.contains("application/vnd.sun.xml.impress"));
    }

    @Test
    @Deploy(value={"org.nuxeo.diff.content:OSGI-INF/test-blacklisted-mime-types-override-contrib.xml"})
    public void testOverriddenHtmlConversionBlacklistedMimeTypes() {
        Set mimeTypes = this.contentDiffAdapterManager.getHtmlConversionBlacklistedMimeTypes();
        Assert.assertEquals((long)3L, (long)mimeTypes.size());
        Assert.assertTrue((boolean)mimeTypes.contains("application/pdf"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/msword"));
        Assert.assertTrue((boolean)mimeTypes.contains("application/rtf"));
        Assert.assertFalse((boolean)mimeTypes.contains("application/vnd.ms-excel"));
        Assert.assertFalse((boolean)mimeTypes.contains("application/vnd.ms-powerpoint"));
    }
}

