/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.content.adapter.base.ContentDiffConversionType;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.diff.content:OSGI-INF/content-diff-adapter-framework.xml"}), @Deploy(value={"org.nuxeo.diff.content:OSGI-INF/content-diff-adapter-contrib.xml"})})
public class TestContentDiffHelper {
    @Inject
    protected CoreSession session;

    @Test
    public void testGetContentDiffURL() {
        DocumentModel leftDoc = this.createDoc(this.session, "leftDoc", "File", "Left doc");
        DocumentModel rightDoc = this.createDoc(this.session, "rightDoc", "File", "Right doc");
        String contentDiffURL = ContentDiffHelper.getContentDiffURL((DocumentModel)leftDoc, (DocumentModel)rightDoc, (String)"file:content", (String)ContentDiffConversionType.html.name(), (String)"en_GB");
        StringBuilder sb = new StringBuilder("restAPI/contentDiff/test/");
        sb.append(leftDoc.getId());
        sb.append("/");
        sb.append(rightDoc.getId());
        sb.append("/file:content/?conversionType=html&locale=en_GB");
        Assert.assertEquals((Object)sb.toString(), (Object)contentDiffURL);
    }

    @Test
    public void testIsDisplayHtmlConversion() {
        String strProp = "A string property";
        Assert.assertTrue((boolean)ContentDiffHelper.isDisplayHtmlConversion((Serializable)((Object)strProp)));
        Blob blob = Blobs.createBlob((String)"A non blacklisted blob", (String)"application/vnd.oasis.opendocument.text");
        Assert.assertTrue((boolean)ContentDiffHelper.isDisplayHtmlConversion((Serializable)((Serializable)blob)));
        blob = Blobs.createBlob((String)"A blacklisted blob", (String)"application/pdf");
        Assert.assertFalse((boolean)ContentDiffHelper.isDisplayHtmlConversion((Serializable)((Serializable)blob)));
    }

    @Test
    public void testIsDisplayTextConversion() {
        String strProp = "A string property";
        Assert.assertFalse((boolean)ContentDiffHelper.isDisplayTextConversion((Serializable)((Object)strProp)));
        Blob blob = Blobs.createBlob((String)"An HTML blob", (String)"text/html");
        Assert.assertFalse((boolean)ContentDiffHelper.isDisplayTextConversion((Serializable)((Serializable)blob)));
        blob = Blobs.createBlob((String)"An OpenDocument blob", (String)"application/vnd.oasis.opendocument.text");
        Assert.assertTrue((boolean)ContentDiffHelper.isDisplayTextConversion((Serializable)((Serializable)blob)));
    }

    @Test
    public void testIsContentProperty() {
        String strProp = "A string property";
        Assert.assertFalse((boolean)ContentDiffHelper.isContentProperty((Serializable)((Object)strProp)));
        Blob blob = Blobs.createBlob((String)"A content property");
        Assert.assertTrue((boolean)ContentDiffHelper.isContentProperty((Serializable)((Serializable)blob)));
    }

    protected DocumentModel createDoc(CoreSession session, String id, String type, String title) {
        DocumentModel doc = session.createDocumentModel("/", id, type);
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        return session.createDocument(doc);
    }
}

