/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.FileSystemItemExists", category="Services", label="Nuxeo Drive: File system item exists", description="Check if the document backing the file system item with the given id exists. Return the result as a JSON blob.")
public class NuxeoDriveFileSystemItemExists {
    public static final String ID = "NuxeoDrive.FileSystemItemExists";
    @Context
    protected OperationContext ctx;
    @Param(name="id", description="Id of the file system item backed by the document whose existence to check.")
    protected String id;

    @OperationMethod
    public Blob run() throws IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        boolean exists = fileSystemItemManager.exists(this.id, this.ctx.getPrincipal());
        return Blobs.createJSONBlobFromValue((Object)exists);
    }
}

