/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations.test;

import org.nuxeo.drive.operations.test.NuxeoDriveIntegrationTestsHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CreateTestDocuments", category="Services", label="Nuxeo Drive: Create test documents")
public class NuxeoDriveCreateTestDocuments {
    public static final String ID = "NuxeoDrive.CreateTestDocuments";
    @Context
    protected CoreSession session;
    @Param(name="namePattern", required=false)
    protected String namePattern = "file_%03d.txt";
    @Param(name="contentPattern", required=false)
    protected String contentPattern = "Content for file_%03d.txt";
    @Param(name="number", required=false)
    protected Integer number = 10;
    @Param(name="delay", required=false)
    protected long delay = 1000L;

    @OperationMethod
    public Blob run(DocumentModel parent) throws Exception {
        NuxeoDriveIntegrationTestsHelper.checkOperationAllowed();
        FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
        for (int i = 0; i < this.number; ++i) {
            String name = String.format(this.namePattern, i);
            StringBlob content = new StringBlob(String.format(this.contentPattern, i));
            content.setFilename(name);
            FileImporterContext context = FileImporterContext.builder((CoreSession)this.session, (Blob)content, (String)parent.getPathAsString()).build();
            fileManager.createOrUpdateDocument(context);
            if (this.delay <= 0L) continue;
            Thread.sleep(this.delay);
        }
        return new StringBlob(this.number.toString(), "text/plain");
    }
}

