/**
 * (C) Copyright 2012 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Olivier Grisel
 */

package org.nuxeo.drive.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.nuxeo.ecm.automation.core.Constants;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;

/**
 * Returns the list of repository names.
 *
 * @deprecated since 10.3
 */
@Deprecated
@Operation(id = GetRepositoriesOperation.ID, category = Constants.CAT_FETCH, label = "List repository names on the server", description = "Return the list of repository names.", deprecatedSince = "10.3")
public class GetRepositoriesOperation {

    public static final String ID = "GetRepositories";

    @Context
    protected RepositoryManager repositoryManager;

    @OperationMethod
    public List<String> run() {
        List<String> repositoryNames = new ArrayList<>(repositoryManager.getRepositoryNames());
        // Make order deterministic to make it simpler to write tests.
        Collections.sort(repositoryNames);
        return repositoryNames;
    }

}
