/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.jaxrs.test;

import com.google.common.base.Splitter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.nuxeo.jaxrs.test.CloseableClientResponse;
import org.nuxeo.jaxrs.test.JerseyClientHelper;

public class HttpClientTestRule
implements TestRule {
    public static final String ADMINISTRATOR = "Administrator";
    private final String url;
    private final String username;
    private final String password;
    private final String accept;
    private final Map<String, String> headers;
    protected Client client;
    protected WebResource service;

    private HttpClientTestRule(Builder builder) {
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.accept = builder.accept;
        this.headers = builder.headers;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HttpClientTestRule.this.starting();
                try {
                    base.evaluate();
                }
                finally {
                    HttpClientTestRule.this.finished();
                }
            }
        };
    }

    public void starting() {
        this.client = JerseyClientHelper.clientBuilder().setCredentials(this.username, this.password).build();
        this.service = this.client.resource(this.url);
    }

    public void finished() {
        this.client.destroy();
    }

    public CloseableClientResponse get(String path) {
        return this.execute(path, builder -> (ClientResponse)builder.get(ClientResponse.class));
    }

    public CloseableClientResponse post(String path, Object data) {
        return this.execute(path, builder -> (ClientResponse)builder.post(ClientResponse.class, data));
    }

    public CloseableClientResponse put(String path, Object data) {
        return this.execute(path, builder -> (ClientResponse)builder.put(ClientResponse.class, data));
    }

    public CloseableClientResponse delete(String path) {
        return this.execute(path, builder -> (ClientResponse)builder.delete(ClientResponse.class));
    }

    protected CloseableClientResponse execute(String path, Function<WebResource.Builder, ClientResponse> invoker) {
        Map queryParams = Collections.emptyMap();
        int interrogationIdx = path.indexOf(63);
        if (interrogationIdx >= 0) {
            queryParams = Splitter.on((char)'&').withKeyValueSeparator('=').split((CharSequence)path.substring(interrogationIdx + 1));
            path = path.substring(0, interrogationIdx);
        }
        WebResource webResource = this.service.path(path);
        for (Map.Entry entry : queryParams.entrySet()) {
            webResource = webResource.queryParam((String)entry.getKey(), (String)entry.getValue());
        }
        WebResource.Builder builder = webResource.accept(new String[]{this.accept});
        this.headers.forEach((arg_0, arg_1) -> ((WebResource.Builder)builder).header(arg_0, arg_1));
        return invoker.andThen(CloseableClientResponse::of).apply(builder);
    }

    public static class Builder {
        private String url = System.getProperty("nuxeoURL", "http://localhost:8080/nuxeo").replaceAll("/$", "");
        private String username = null;
        private String password = null;
        private String accept = null;
        private Map<String, String> headers = new HashMap<String, String>();

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder adminCredentials() {
            return this.credentials(HttpClientTestRule.ADMINISTRATOR, HttpClientTestRule.ADMINISTRATOR);
        }

        public Builder credentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public HttpClientTestRule build() {
            return new HttpClientTestRule(this);
        }
    }
}

