/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.test;

import org.nuxeo.runtime.test.runner.web.WebPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.How;

public class LoginPage
extends WebPage {
    @FindBy(how=How.ID, using="username")
    protected WebElement inputUsername;
    @FindBy(how=How.ID, using="password")
    protected WebElement inputPassword;
    @FindBy(how=How.NAME, using="nuxeo_login")
    protected WebElement login;
    @FindBy(how=How.ID, using="logout")
    protected WebElement logout;
    @FindBy(how=How.ID, using="logstate")
    protected WebElement logstate;

    public void login(String username, String password) {
        this.inputUsername.clear();
        this.inputUsername.sendKeys(new CharSequence[]{username});
        this.inputPassword.clear();
        this.inputPassword.sendKeys(new CharSequence[]{password});
        this.login.click();
    }

    public void ensureLogin(String username, String password) {
        this.login(username, password);
        this.isAuthenticated(5);
    }

    public void logout() {
        this.logout.click();
    }

    public void ensureLogout() {
        this.logout();
        this.isNotAuthenticated(5);
    }

    public boolean isAuthenticated(int timeoutInSeconds) {
        try {
            this.findElement(By.id((String)"logout"), timeoutInSeconds);
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public boolean isNotAuthenticated(int timeoutInSeconds) {
        try {
            this.findElement(By.id((String)"login"), timeoutInSeconds);
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public boolean isAuthenticated() {
        try {
            this.driver.findElement(By.id((String)"logout"));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

