/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.restapi.jaxrs.io.conversion.ConversionScheduled;
import org.nuxeo.ecm.restapi.server.jaxrs.blob.BlobObject;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="convert", type="convertAdapter")
@Produces(value={"application/json"})
public class ConvertAdapter
extends DefaultAdapter {
    public static final String NAME = "convert";

    @GET
    public Blob convert(@QueryParam(value="converter") String converter, @QueryParam(value="type") String type, @QueryParam(value="format") String format, @Context UriInfo uriInfo) {
        BlobHolder bh = this.getBlobHolderToConvert();
        if (StringUtils.isNotBlank((CharSequence)converter)) {
            return this.convertWithConverter(bh, converter, uriInfo);
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            return this.convertWithMimeType(bh, type, uriInfo);
        }
        if (StringUtils.isNotBlank((CharSequence)format)) {
            return this.convertWithFormat(bh, format, uriInfo);
        }
        throw new IllegalParameterException("No converter, type or format parameter specified");
    }

    protected BlobHolder getBlobHolderToConvert() {
        DocumentModel doc;
        Blob blob = (Blob)this.getTarget().getAdapter(Blob.class);
        DocumentBlobHolder bh = null;
        if (blob == null && (doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class)) != null && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null) {
            blob = bh.getBlob();
        }
        if (blob == null) {
            throw new IllegalParameterException("No Blob found");
        }
        if (this.getTarget().isInstanceOf("blob")) {
            bh = ((BlobObject)this.getTarget()).getBlobHolder();
        }
        if (bh == null) {
            bh = new SimpleBlobHolder(blob);
        }
        return bh;
    }

    protected Blob convertWithConverter(BlobHolder bh, String converter, UriInfo uriInfo) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        if (!conversionService.isConverterAvailable(converter).isAvailable()) {
            throw new IllegalParameterException(String.format("The '%s' converter is not available", converter));
        }
        Map<String, Serializable> parameters = this.computeConversionParameters(uriInfo);
        BlobHolder blobHolder = conversionService.convert(converter, bh, parameters);
        Blob conversionBlob = blobHolder.getBlob();
        if (conversionBlob == null) {
            throw new WebResourceNotFoundException(String.format("No converted Blob using '%s' converter", converter));
        }
        return conversionBlob;
    }

    protected Map<String, Serializable> computeConversionParameters(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        for (String parameterKey : queryParams.keySet()) {
            parameters.put(parameterKey, (Serializable)queryParams.getFirst((Object)parameterKey));
        }
        return parameters;
    }

    protected Blob convertWithMimeType(BlobHolder bh, String mimeType, UriInfo uriInfo) {
        Map<String, Serializable> parameters = this.computeConversionParameters(uriInfo);
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder blobHolder = conversionService.convertToMimeType(mimeType, bh, parameters);
        Blob conversionBlob = blobHolder.getBlob();
        if (conversionBlob == null) {
            throw new WebResourceNotFoundException(String.format("No converted Blob for '%s' mime type", mimeType));
        }
        return conversionBlob;
    }

    protected Blob convertWithFormat(BlobHolder bh, String format, UriInfo uriInfo) {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimeType = mimetypeRegistry.getMimetypeFromExtension(format);
        return this.convertWithMimeType(bh, mimeType, uriInfo);
    }

    @POST
    public Object convert(@FormParam(value="converter") String converter, @FormParam(value="type") String type, @FormParam(value="format") String format, @FormParam(value="async") boolean async, @Context UriInfo uriInfo) {
        String conversionId;
        if (!async) {
            return this.convert(converter, type, format, uriInfo);
        }
        BlobHolder bh = this.getBlobHolderToConvert();
        Map<String, Serializable> parameters = this.computeConversionParameters(uriInfo);
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        if (StringUtils.isNotBlank((CharSequence)converter)) {
            conversionId = conversionService.scheduleConversion(converter, bh, parameters);
        } else if (StringUtils.isNotBlank((CharSequence)type)) {
            conversionId = conversionService.scheduleConversionToMimeType(type, bh, parameters);
        } else if (StringUtils.isNotBlank((CharSequence)format)) {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String mimeType = mimetypeRegistry.getMimetypeFromExtension(format);
            conversionId = conversionService.scheduleConversionToMimeType(mimeType, bh, parameters);
        } else {
            throw new IllegalParameterException("No converter, type or format parameter specified");
        }
        String serverURL = StringUtils.stripEnd((String)this.ctx.getServerURL().toString(), (String)"/");
        String pollingURL = String.format("%s%s/conversions/%s/poll", serverURL, this.ctx.getModulePath(), conversionId);
        String resultURL = String.format("%s%s/conversions/%s/result", serverURL, this.ctx.getModulePath(), conversionId);
        ConversionScheduled conversionScheduled = new ConversionScheduled(conversionId, pollingURL, resultURL);
        try {
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(new URI(pollingURL)).entity((Object)conversionScheduled).build();
        }
        catch (URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

