/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonReader;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;

@WebObject(type="Document")
@Produces(value={"application/json", "application/json+esentity"})
public class JSONDocumentObject
extends DocumentObject {
    protected static final Log log = LogFactory.getLog(JSONDocumentObject.class);
    private boolean isVersioning;

    @GET
    public DocumentModel doGet() {
        return this.doc;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response doPut(DocumentModel inputDoc, @Context HttpHeaders headers) {
        DocumentModelJsonReader.applyPropertyValues((DocumentModel)inputDoc, (DocumentModel)this.doc);
        CoreSession session = this.ctx.getCoreSession();
        this.versioningDocFromHeaderIfExists(this.doc, headers);
        this.updateCommentFromHeader(headers);
        try {
            this.doc = session.saveDocument(this.doc);
            session.save();
        }
        catch (ConcurrentUpdateException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Invalid change token").build();
        }
        DocumentModel returnedDoc = this.isVersioning ? session.getLastDocumentVersion(this.doc.getRef()) : this.doc;
        return Response.ok((Object)returnedDoc).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response doPost(DocumentModel inputDoc, @Context HttpHeaders headers) {
        CoreSession session = this.ctx.getCoreSession();
        if (StringUtils.isBlank((CharSequence)inputDoc.getType()) || StringUtils.isBlank((CharSequence)inputDoc.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"type or name property is missing").build();
        }
        DocumentModel createdDoc = session.createDocumentModel(this.doc.getPathAsString(), inputDoc.getName(), inputDoc.getType());
        DocumentModelJsonReader.applyPropertyValues((DocumentModel)inputDoc, (DocumentModel)createdDoc);
        this.versioningDocFromHeaderIfExists(createdDoc, headers);
        createdDoc = session.createDocument(createdDoc);
        session.save();
        return Response.ok((Object)createdDoc).status(Response.Status.CREATED).build();
    }

    @DELETE
    public Response doDelete() {
        super.doDelete();
        return Response.noContent().build();
    }

    @Path(value="@search")
    public Object search() {
        return this.ctx.newAdapter((Resource)this, "search", new Object[0]);
    }

    public DocumentObject newDocument(String path) {
        PathRef pathRef = new PathRef(this.doc.getPath().append(path).toString());
        DocumentModel doc = this.ctx.getCoreSession().getDocument((DocumentRef)pathRef);
        return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
    }

    public DocumentObject newDocument(DocumentRef ref) {
        DocumentModel doc = this.ctx.getCoreSession().getDocument(ref);
        return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
    }

    public DocumentObject newDocument(DocumentModel doc) {
        return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
    }

    private void versioningDocFromHeaderIfExists(DocumentModel doc, HttpHeaders headers) {
        this.isVersioning = false;
        List versionHeader = headers.getRequestHeader("X-Versioning-Option");
        List sourceHeader = headers.getRequestHeader("source");
        if (versionHeader != null && !versionHeader.isEmpty()) {
            VersioningOption versioningOption = VersioningOption.valueOf((String)((String)versionHeader.get(0)).toUpperCase());
            if (!versioningOption.equals((Object)VersioningOption.NONE)) {
                doc.putContextData("VersioningOption", (Serializable)versioningOption);
                this.isVersioning = true;
            }
        } else if (sourceHeader != null && !sourceHeader.isEmpty()) {
            doc.putContextData("source", (Serializable)sourceHeader.get(0));
            this.isVersioning = true;
        }
    }

    protected void updateCommentFromHeader(HttpHeaders headers) {
        List updateCommentHeader = headers.getRequestHeader("Update-Comment");
        if (updateCommentHeader != null && !updateCommentHeader.isEmpty()) {
            String comment = (String)updateCommentHeader.get(0);
            this.doc.putContextData("comment", (Serializable)((Object)comment));
        }
    }
}

