/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.conversion;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConversionStatus;
import org.nuxeo.ecm.restapi.jaxrs.io.conversion.ConversionStatusWithResult;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="conversions")
public class ConversionRootObject
extends DefaultObject {
    @GET
    @Path(value="{id}/poll")
    public Object doGetConversionStatus(@PathParam(value="id") String id) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        ConversionStatus conversionStatus = conversionService.getConversionStatus(id);
        if (conversionStatus == null) {
            throw new WebResourceNotFoundException("No conversion job for id: " + id);
        }
        String serverURL = this.ctx.getServerURL().toString().replaceAll("/$", "");
        String resultURL = String.format("%s%s/conversions/%s/result", serverURL, this.ctx.getModulePath(), conversionStatus.id);
        ConversionStatusWithResult conversionStatusWithResult = new ConversionStatusWithResult(conversionStatus, resultURL);
        return Response.ok((Object)conversionStatusWithResult).build();
    }

    @GET
    @Path(value="{id}/result")
    public Object doGetConversionResult(@PathParam(value="id") String id) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = conversionService.getConversionResult(id, false);
        if (result == null || result.getBlob() == null) {
            throw new WebResourceNotFoundException("No conversion result for id: " + id);
        }
        return result.getBlob();
    }
}

