/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="me")
@Produces(value={"application/json"})
public class MeObject
extends DefaultObject {
    @GET
    public NuxeoPrincipal doGet(@Context Request request) {
        return this.getContext().getCoreSession().getPrincipal();
    }

    @PUT
    @Path(value="changepassword")
    public Object changePassword(String payload) throws JSONException {
        NuxeoPrincipal currentUser = this.getContext().getCoreSession().getPrincipal();
        JSONObject payloadJson = new JSONObject(payload);
        String oldPassword = payloadJson.getString("oldPassword");
        String newPassword = payloadJson.getString("newPassword");
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager.checkUsernamePassword(currentUser.getName(), oldPassword)) {
            currentUser.setPassword(newPassword);
            Framework.doPrivileged(() -> userManager.updateUser(currentUser.getModel()));
            return currentUser;
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

