/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="management")
public class ManagementObject
extends AbstractResource<ResourceTypeImpl> {
    public static final String MANAGEMENT_OBJECT_PREFIX = "management/";
    protected static final String MANAGEMENT_API_HTTP_PORT_PROPERTY = "nuxeo.management.api.http.port";
    protected static final String MANAGEMENT_API_USER_PROPERTY = "nuxeo.management.api.user";
    @Context
    protected HttpServletRequest request;

    protected void initialize(Object ... args) {
        if (!this.requestIsOnConfiguredPort((ServletRequest)this.request)) {
            throw new NuxeoException(404);
        }
        if (!this.isUserValid(this.request)) {
            throw new NuxeoException(403);
        }
    }

    @Path(value="{path}")
    public Object route(@PathParam(value="path") String path) {
        return this.newObject(MANAGEMENT_OBJECT_PREFIX + path, new Object[0]);
    }

    protected boolean requestIsOnConfiguredPort(ServletRequest request) {
        int port = request.getLocalPort();
        String configPort = Framework.getProperty((String)MANAGEMENT_API_HTTP_PORT_PROPERTY, (String)Framework.getProperty((String)"nuxeo.server.http.port"));
        return Integer.parseInt(configPort) == port;
    }

    protected boolean isUserValid(HttpServletRequest request) {
        if (!(request.getUserPrincipal() instanceof NuxeoPrincipal)) {
            return false;
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)request.getUserPrincipal();
        String managementUser = Framework.getProperty((String)MANAGEMENT_API_USER_PROPERTY);
        return principal.getName().equals(managementUser) || principal.isAdministrator();
    }
}

