/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.restapi.test.RestServerFeature;
import org.nuxeo.jaxrs.test.HttpClientTestRule;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;
import org.nuxeo.runtime.test.runner.TransactionalFeature;
import org.skyscreamer.jsonassert.JSONAssert;

@RunWith(value=FeaturesRunner.class)
@Features(value={RestServerFeature.class})
public abstract class ManagementBaseTest {
    @Inject
    protected ServletContainerFeature servletContainerFeature;
    @Inject
    protected TransactionalFeature txFeature;
    protected ObjectMapper mapper = new ObjectMapper();
    protected HttpClientTestRule httpClientRule;

    protected HttpClientTestRule getRule() {
        String url = String.format("http://localhost:%d/api/v1", this.servletContainerFeature.getPort());
        return new HttpClientTestRule.Builder().url(url).accept("*/*").credentials("Administrator", "Administrator").build();
    }

    @Before
    public void before() {
        this.httpClientRule = this.getRule();
        this.httpClientRule.starting();
    }

    @After
    public void after() {
        this.httpClientRule.finished();
    }

    protected void assertJsonResponse(String actual, String expectedFile) throws IOException, JSONException {
        File file = org.nuxeo.common.utils.FileUtils.getResourceFileFromContext((String)expectedFile);
        String expected = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    protected String getBulkCommandId(JsonNode bulkStatus) {
        return bulkStatus.get("commandId").asText();
    }

    protected void assertBulkStatusScheduled(JsonNode bulkStatus) {
        Assert.assertEquals((Object)BulkStatus.State.SCHEDULED.name(), (Object)bulkStatus.get("state").asText());
    }

    protected void assertBulkStatusCompleted(JsonNode bulkStatus) {
        Assert.assertEquals((Object)BulkStatus.State.COMPLETED.name(), (Object)bulkStatus.get("state").asText());
        Instant completed = Instant.parse(bulkStatus.get("completed").asText());
        Assert.assertTrue((boolean)completed.isBefore(Instant.now()));
        Assert.assertNotNull((Object)bulkStatus.get("processingMillis"));
    }
}

