/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;
import org.nuxeo.runtime.api.Framework;

public class UpdateThumbnailListener
implements PostCommitEventListener {
    public static final String THUMBNAIL_UPDATED = "thumbnailUpdated";

    protected void processDoc(CoreSession session, DocumentModel doc) {
        Blob thumbnailBlob = this.getManagedThumbnail(doc);
        if (thumbnailBlob == null) {
            ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)doc.getAdapter(ThumbnailAdapter.class);
            if (thumbnailAdapter == null) {
                return;
            }
            thumbnailBlob = thumbnailAdapter.computeThumbnail(session);
        }
        if (thumbnailBlob != null) {
            if (!doc.hasFacet("Thumbnail")) {
                doc.addFacet("Thumbnail");
            }
            doc.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
        } else if (doc.hasFacet("Thumbnail")) {
            doc.setPropertyValue("thumb:thumbnail", null);
            doc.removeFacet("Thumbnail");
        }
        if (doc.isDirty()) {
            doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
            doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
            doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            doc.putContextData(THUMBNAIL_UPDATED, (Serializable)Boolean.valueOf(true));
            session.saveDocument(doc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Blob getManagedThumbnail(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        Blob blob3 = bh.getBlob();
        if (blob3 == null) {
            return null;
        }
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try (InputStream is = blobManager.getThumbnail(blob3);){
            if (is == null) {
                Blob blob2 = null;
                return blob2;
            }
            Blob blob = Blobs.createBlob((InputStream)is);
            return blob;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to get managed blob thumbnail", (Throwable)e);
        }
    }

    public void handleEvent(EventBundle events) {
        if (!events.containsEventName(ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name())) {
            return;
        }
        HashSet<String> processedDocs = new HashSet<String>();
        for (Event event : events) {
            DocumentEventContext context;
            DocumentModel doc;
            if (!ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name().equals(event.getName()) || (doc = (context = (DocumentEventContext)event.getContext()).getSourceDocument()) instanceof DeletedDocumentModel || doc.isProxy() || processedDocs.contains(doc.getId())) continue;
            CoreSession repo = context.getCoreSession();
            this.processDoc(repo, doc);
            processedDocs.add(doc.getId());
        }
    }
}

