/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.usermapper.extension.GroovyUserMapper;
import org.nuxeo.usermapper.extension.NashornUserMapper;
import org.nuxeo.usermapper.extension.UserMapper;

@XObject(value="mapper")
public class UserMapperDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@type")
    protected String type;
    @XNode(value="@class")
    Class<UserMapper> mapperClass;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> params;
    @XNode(value="mapperScript")
    protected String mapperScript;
    @XNode(value="wrapperScript")
    protected String wrapperScript;

    public UserMapper getInstance() throws Exception {
        UserMapper mapper = null;
        switch (this.getType()) {
            case java: {
                if (this.mapperClass == null) {
                    throw new NuxeoException("Java Mapper must provide an implementation class ");
                }
                mapper = this.mapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                break;
            }
            case groovy: {
                mapper = new GroovyUserMapper(this.mapperScript, this.wrapperScript);
                break;
            }
            case javascript: {
                mapper = new NashornUserMapper(this.mapperScript, this.wrapperScript);
                break;
            }
            default: {
                throw new NuxeoException("Mapper has an unknown type");
            }
        }
        mapper.init(this.params);
        return mapper;
    }

    public Type getType() {
        if (this.type == null && this.mapperClass != null) {
            return Type.java;
        }
        if ("java".equalsIgnoreCase(this.type)) {
            return Type.java;
        }
        if ("groovy".equalsIgnoreCase(this.type)) {
            return Type.groovy;
        }
        if ("javascript".equalsIgnoreCase(this.type)) {
            return Type.javascript;
        }
        if ("js".equalsIgnoreCase(this.type)) {
            return Type.javascript;
        }
        return Type.none;
    }

    public static enum Type {
        java,
        groovy,
        javascript,
        none;

    }
}

