/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.api;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.web.resources.api.Resource;

public enum ResourceType {
    any,
    unknown,
    css,
    js,
    bundle,
    html,
    jsfjs,
    jsfcss,
    xhtml,
    xhtmlfirst;


    public String getSuffix() {
        return "." + this.name();
    }

    public final boolean equals(String type) {
        return this.name().equalsIgnoreCase(type);
    }

    public final boolean matches(Resource r) {
        if (any == this) {
            return true;
        }
        if (r == null || r.getType() == null) {
            return true;
        }
        return this.equals(r.getType());
    }

    public static final ResourceType parse(String type) {
        for (ResourceType item : ResourceType.values()) {
            if (!item.equals(type)) continue;
            return item;
        }
        return unknown;
    }

    public static final boolean matches(String type, Resource r) {
        if (StringUtils.isBlank((CharSequence)type) || any.equals(type)) {
            return true;
        }
        String rt = r.getType();
        if (StringUtils.isBlank((CharSequence)rt)) {
            return true;
        }
        return type.equalsIgnoreCase(rt);
    }
}

