/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Thierry Delprat
 */
package org.nuxeo.ecm.webdav.service;

import org.nuxeo.ecm.webdav.backend.BackendFactory;
import org.nuxeo.ecm.webdav.backend.SearchBackendFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebDavService extends DefaultComponent {

    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.webdav.service");

    public static final String BACKEND_FACTORY_XP = "backendFactory";

    protected BackendFactory backendFactory = new SearchBackendFactory();

    public static WebDavService instance() {
        return (WebDavService) Framework.getRuntime().getComponent(WebDavService.NAME);
    }

    public BackendFactory getBackendFactory() {
        return backendFactory;
    }

    // used by tests
    public void setBackendFactory(BackendFactory backendFactory) {
        this.backendFactory = backendFactory;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (BACKEND_FACTORY_XP.equals(extensionPoint)) {
            BackendFactoryDescriptor desc = (BackendFactoryDescriptor) contribution;
            Class<?> factoryClass = desc.getFactoryClass();
            try {
                backendFactory = (BackendFactory) factoryClass.getDeclaredConstructor().newInstance();
            } catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

}
