/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.util.Date;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="lock", type="LockService", targetType="Document")
public class LockService
extends DefaultAdapter {
    @GET
    public Object doGet() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            Lock lock = this.ctx.getCoreSession().getLockInfo(doc.getRef());
            return lock.getOwner() + "/" + DateUtils.formatISODateTime((Date)lock.getCreated().getTime());
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to get lock on document");
            throw e;
        }
    }

    @DELETE
    public Object removeLock() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().removeLock(doc.getRef());
            doc.refresh();
            return null;
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to unlock document");
            throw e;
        }
    }

    @POST
    public Object doPost() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().setLock(doc.getRef());
            doc.refresh();
            return null;
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to lock document");
            throw e;
        }
    }
}

