/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static DocumentModel createDocument(WebContext context, DocumentModel parent, String name) {
        FormData form = context.getForm();
        String type = form.getDocumentType();
        if (type == null) {
            throw new NuxeoException("Invalid argument exception. No doc type specified");
        }
        try {
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            CoreSession session = context.getCoreSession();
            DocumentModel newDoc = session.createDocumentModel(type);
            form.fillDocument(newDoc);
            if (name != null) {
                newDoc.setPropertyValue("dc:title", (Serializable)((Object)name));
            }
            newDoc.setPathInfo(parent.getPathAsString(), pss.generatePathSegment(newDoc));
            newDoc = session.createDocument(newDoc);
            newDoc.setPropertyValue("dc:title", (Serializable)((Object)newDoc.getName()));
            session.saveDocument(newDoc);
            session.save();
            return newDoc;
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to create document: " + name);
            throw e;
        }
    }

    public static DocumentModel updateDocument(WebContext ctx, DocumentModel doc) {
        FormData form = ctx.getForm();
        form.fillDocument(doc);
        doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
        doc = ctx.getCoreSession().saveDocument(doc);
        ctx.getCoreSession().save();
        return doc;
    }
}

