/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.session;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionRef;

public abstract class CoreSessionProvider<REF extends SessionRef> {
    protected Map<String, REF> sessions = new HashMap<String, REF>();

    protected CoreSessionProvider() {
    }

    protected abstract void onRequestDone(HttpServletRequest var1);

    protected abstract REF createSessionRef(CloseableCoreSession var1);

    public SessionRef[] getSessions() {
        return this.sessions.values().toArray(new SessionRef[this.sessions.size()]);
    }

    public SessionRef getSessionRef(HttpServletRequest request, String repoName) {
        SessionRef ref = (SessionRef)this.sessions.get(repoName);
        if (ref == null) {
            ref = this.createSessionRef(this.createSession(request, repoName));
            this.sessions.put(repoName, ref);
        }
        return ref;
    }

    public CoreSession getSession(HttpServletRequest request, String repoName) {
        return this.getSessionRef(request, repoName).get();
    }

    protected CloseableCoreSession createSession(HttpServletRequest request, String repoName) {
        if (request.getUserPrincipal() == null) {
            throw new IllegalStateException("Not authenticated user is trying to get a core session");
        }
        return CoreInstance.openCoreSession((String)repoName);
    }

    public boolean hasSessions() {
        return !this.sessions.isEmpty();
    }

    protected void destroy() {
        for (SessionRef ref : this.getSessions()) {
            ref.destroy();
        }
        this.sessions = null;
    }
}

