/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.jaxrs.BundleNotFoundException;
import org.nuxeo.ecm.webengine.jaxrs.Utils;
import org.nuxeo.ecm.webengine.jaxrs.servlet.FilterSet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ListenerSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;
import org.osgi.framework.Bundle;

@XObject(value="servlet")
public class ServletDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected String classRef;
    @XNode(value="@path")
    protected String path;
    @XNode(value="resources")
    protected String resources;
    @XNodeMap(value="properties/property", key="@name", type=HashMap.class, componentType=String.class, trim=true, nullByDefault=false)
    protected HashMap<String, String> initParams;
    @XNodeList(value="filters", type=ArrayList.class, componentType=FilterSetDescriptor.class, nullByDefault=false)
    protected ArrayList<FilterSetDescriptor> filters;
    @XNode(value="listeners")
    protected ListenerSetDescriptor listeners;
    protected Bundle bundle;
    private Utils.ClassRef ref;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.path;
    }

    public HashMap<String, String> getInitParams() {
        return this.initParams;
    }

    public Utils.ClassRef getClassRef() throws ClassNotFoundException, BundleNotFoundException {
        if (this.ref == null) {
            this.ref = Utils.getClassRef(this.classRef, this.bundle);
        }
        return this.ref;
    }

    public HttpServlet getServlet() throws ReflectiveOperationException, BundleNotFoundException {
        return (HttpServlet)this.getClassRef().get().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public ListenerSetDescriptor getListenerSet() {
        return this.listeners;
    }

    public String getResources() {
        return this.resources;
    }

    public FilterSet[] getFilters() {
        int i;
        List<FilterSetDescriptor> list = ServletRegistry.getInstance().getFiltersFor(this.name);
        int len1 = list.size();
        int len2 = this.filters.size();
        FilterSet[] filterSets = new FilterSet[len1 + len2];
        for (i = 0; i < len1; ++i) {
            filterSets[i] = list.get(i).getFilterSet();
        }
        for (i = 0; i < len2; ++i) {
            filterSets[i + len1] = this.filters.get(i).getFilterSet();
        }
        return filterSets;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name).append(" { ").append(this.path).append(" [").append(this.classRef).append("]");
        buf.append("\n  Properties: ").append(this.initParams);
        if (!this.filters.isEmpty()) {
            buf.append("\n  Filters:\n    ");
            for (FilterSetDescriptor fsd : this.filters) {
                buf.append(fsd.toString());
                buf.append("\n    ");
            }
        }
        if (this.listeners != null) {
            buf.append("\n  Listeners: ").append(this.listeners.toString());
        }
        buf.append("\n}\n");
        return buf.toString();
    }
}

