/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.webengine.jaxrs.scan.AnnotationReader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Bundle;

public class Scanner {
    public static final String PATH_ANNO = "Ljavax/ws/rs/Path;";
    public static final String PROVIDER_ANNO = "Ljavax/ws/rs/ext/Provider;";
    protected Bundle bundle;
    protected String packageBase;
    protected Map<String, Collection<Class<?>>> collectors;

    public Scanner(Bundle bundle, String packageBase) {
        this(bundle, packageBase, PATH_ANNO, PROVIDER_ANNO);
    }

    public Scanner(Bundle bundle, String packageBase, String ... annotations) {
        this.bundle = bundle;
        this.packageBase = packageBase == null ? "/" : packageBase;
        this.collectors = new HashMap();
        for (String annotation : annotations) {
            this.addCollector(annotation);
        }
    }

    public void addCollector(String annotation) {
        this.collectors.put(annotation, new ArrayList());
    }

    public void addCollector(String annotation, Collection<Class<?>> collector) {
        this.collectors.put(annotation, collector);
    }

    public Collection<Class<?>> getCollector(String annotation) {
        return this.collectors.get(annotation);
    }

    public Map<String, Collection<Class<?>>> getCollectors() {
        return this.collectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws ReflectiveOperationException, IOException {
        Enumeration urls = this.bundle.findEntries(this.packageBase, "*.class", true);
        if (urls == null) {
            return;
        }
        Set<String> annotations = this.collectors.keySet();
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            try (InputStream in = url.openStream();){
                ClassReader cr = new ClassReader(in);
                AnnotationReader reader = new AnnotationReader(annotations);
                cr.accept((ClassVisitor)reader, null, 7);
                if (!reader.hasResults()) continue;
                String cname = reader.getClassName();
                for (String anno : reader.getResults()) {
                    this.collectors.get(anno).add(this.bundle.loadClass(cname));
                }
            }
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        for (Collection<Class<?>> c : this.collectors.values()) {
            result.addAll(c);
        }
        return result;
    }

    public Set<Class<?>> getClasses(String anno) {
        return new HashSet(this.collectors.get(anno));
    }
}

