/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.coreiodelegate;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=1000)
@Supports(value={"application/json"})
public class DocumentModelJsonReaderLegacy
implements Reader<DocumentModel> {
    private static final Log log = LogFactory.getLog(DocumentModelJsonReaderLegacy.class);
    public static final String CONF_DOCUMENT_JSON_LEGACY = "nuxeo.document.json.legacy";
    public static final String HEADER_DOCUMENT_JSON_LEGACY = "X-NXDocumentJsonLegacy";
    private static boolean IS_METHOD_LOADED = false;
    private static Method METHOD = null;
    private static Boolean CONF_KEY = null;
    private HttpServletRequest request;
    private MultivaluedMap<String, String> httpHeaders;

    private static void loadMethod() {
        try {
            Method method;
            Class<?> legacy = Class.forName("org.nuxeo.ecm.automation.jaxrs.io.documents.JSONDocumentModelReader");
            METHOD = method = legacy.getMethod("readJson", JsonParser.class, MultivaluedMap.class, HttpServletRequest.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            log.error((Object)"Unable to find method org.nuxeo.ecm.automation.jaxrs.io.documents.JSONDocumentModelReader.readJson(JsonParser, MultivaluedMap<String, String>, HttpServletRequest)", (Throwable)e);
            return;
        }
    }

    private static boolean getConfKey() {
        if (CONF_KEY == null) {
            CONF_KEY = Framework.isBooleanPropertyTrue((String)CONF_DOCUMENT_JSON_LEGACY);
        }
        return CONF_KEY;
    }

    public static void pushInstanceIfNeeded(RenderingContext ctx, HttpServletRequest request, MultivaluedMap<String, String> httpHeaders) {
        if (!IS_METHOD_LOADED) {
            DocumentModelJsonReaderLegacy.loadMethod();
        }
        if (METHOD == null) {
            return;
        }
        String header = request.getHeader(HEADER_DOCUMENT_JSON_LEGACY);
        if (header != null) {
            try {
                boolean enable = Boolean.valueOf(header);
                if (enable) {
                    DocumentModelJsonReaderLegacy instance = new DocumentModelJsonReaderLegacy(request, httpHeaders);
                    ctx.setParameterValues("DocumentModelLegacyModeReader", new Object[]{instance});
                    return;
                }
                return;
            }
            catch (Exception e) {
                log.warn((Object)"Invalid header value for X-NXDocumentJsonLegacy : true|false");
            }
        }
        if (DocumentModelJsonReaderLegacy.getConfKey()) {
            DocumentModelJsonReaderLegacy instance = new DocumentModelJsonReaderLegacy(request, httpHeaders);
            ctx.setParameterValues("DocumentModelLegacyModeReader", new Object[]{instance});
            return;
        }
    }

    private DocumentModelJsonReaderLegacy(HttpServletRequest request, MultivaluedMap<String, String> httpHeaders) {
        this.request = request;
        this.httpHeaders = httpHeaders;
    }

    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    public DocumentModel read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        DocumentModel documentModel;
        block8: {
            JsonParser parser = JsonFactoryProvider.get().createJsonParser(in);
            try {
                documentModel = (DocumentModel)DocumentModel.class.cast(METHOD.invoke(null, parser, this.httpHeaders, this.request));
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.error((Object)"Unable to use legacy document model reading", (Throwable)e);
                    return null;
                }
            }
            parser.close();
        }
        return documentModel;
    }
}

