/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFragment;
import org.nuxeo.ecm.webengine.jaxrs.Reloadable;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourceExtension;
import org.nuxeo.ecm.webengine.jaxrs.views.BundleResource;
import org.nuxeo.ecm.webengine.jaxrs.views.TemplateViewMessageBodyWriter;
import org.nuxeo.ecm.webengine.jaxrs.views.ViewMessageBodyWriter;
import org.osgi.framework.Bundle;

public class ApplicationHost
extends Application {
    private static final Log log = LogFactory.getLog(ApplicationHost.class);
    protected final String name;
    protected final Map<String, Boolean> features = new HashMap<String, Boolean>();
    protected final List<ApplicationFragment> apps;
    protected List<Reloadable> listeners;
    protected RenderingEngine rendering;
    protected Map<String, ResourceExtension> extensions;
    protected HashMap<Class<?>, Bundle> class2Bundles;

    public ApplicationHost(String name) {
        this.name = name;
        this.apps = new ArrayList<ApplicationFragment>();
        this.class2Bundles = new HashMap();
        this.listeners = new ArrayList<Reloadable>();
        this.extensions = new HashMap<String, ResourceExtension>();
    }

    public BundleResource getExtension(BundleResource target, String segment) {
        BundleResource res;
        ResourceExtension xt = this.getExtension(target.getClass().getName() + "#" + segment);
        if (xt != null && (res = target.getResource(xt.getResourceClass())) != null && res.accept(target)) {
            res.getContext().pushBundle(xt.getBundle());
            return res;
        }
        return null;
    }

    public RenderingEngine getRendering() {
        return this.rendering;
    }

    public void setRendering(RenderingEngine rendering) {
        this.rendering = rendering;
    }

    public synchronized void addExtension(ResourceExtension xt) {
        this.extensions.put(xt.getId(), xt);
        this.class2Bundles.put(xt.getResourceClass(), xt.getBundle());
        if (this.rendering != null) {
            this.rendering.flushCache();
        }
    }

    public synchronized void removeExtension(ResourceExtension xt) {
        this.extensions.remove(xt.getId());
        this.class2Bundles.remove(xt.getResourceClass());
        if (this.rendering != null) {
            this.rendering.flushCache();
        }
    }

    public synchronized ResourceExtension getExtension(String id) {
        return this.extensions.get(id);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public synchronized void add(ApplicationFragment app) {
        this.apps.add(app);
    }

    public synchronized void remove(ApplicationFragment app) {
        this.apps.remove((Object)app);
    }

    public synchronized ApplicationFragment[] getApplications() {
        return this.apps.toArray(new ApplicationFragment[this.apps.size()]);
    }

    public synchronized void addReloadListener(Reloadable listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeReloadListener(Reloadable listener) {
        this.listeners.remove(listener);
    }

    public synchronized void reload() {
        for (ApplicationFragment fragment : this.apps) {
            fragment.reload();
        }
        this.class2Bundles = new HashMap();
        for (Reloadable listener : this.listeners) {
            listener.reload();
        }
        if (this.rendering != null) {
            this.rendering.flushCache();
        }
    }

    public Bundle getBundle(Class<?> clazz) {
        return this.class2Bundles.get(clazz);
    }

    public synchronized Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        for (ApplicationFragment app : this.getApplications()) {
            try {
                for (Class<?> clazz : app.getClasses()) {
                    if (clazz.isAnnotationPresent(Path.class)) {
                        this.class2Bundles.put(clazz, app.getBundle());
                    }
                    result.add(clazz);
                }
            }
            catch (LinkageError e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public synchronized Set<Object> getSingletons() {
        HashSet<Object> result = new HashSet<Object>();
        result.add(new TemplateViewMessageBodyWriter());
        result.add(new ViewMessageBodyWriter());
        for (ApplicationFragment app : this.getApplications()) {
            for (Object obj : app.getSingletons()) {
                if (obj.getClass().isAnnotationPresent(Path.class)) {
                    this.class2Bundles.put(obj.getClass(), app.getBundle());
                }
                result.add(obj);
            }
        }
        return result;
    }
}

