/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.nuxeo.lib.stream.codec.Codec;

public class AvroJsonCodec<T>
implements Codec<T> {
    public static final String NAME = "avroJson";
    protected final Class<T> messageClass;
    protected final Schema schema;
    protected final ReflectDatumWriter<T> writer;
    protected final ReflectDatumReader<T> reader;

    public AvroJsonCodec(Class<T> messageClass) {
        this.messageClass = messageClass;
        this.schema = ReflectData.get().getSchema(messageClass);
        this.writer = new ReflectDatumWriter(this.schema);
        this.reader = new ReflectDatumReader(this.schema);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] encode(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(this.schema, (OutputStream)baos);
            this.writer.write(object, (Encoder)jsonEncoder);
            jsonEncoder.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T decode(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(this.schema, (InputStream)bais);
            return (T)this.reader.read(null, (Decoder)jsonDecoder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

