/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import net.openhft.chronicle.queue.impl.CommonStore;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;

public class ChronicleRetentionListener
implements StoreFileListener {
    private static final Logger log = LogManager.getLogger(ChronicleRetentionListener.class);
    protected final ChronicleRetentionDuration retention;
    protected SingleChronicleQueue queue;
    protected long purgedStamp;

    public ChronicleRetentionListener(ChronicleRetentionDuration retention) {
        this.retention = retention;
    }

    public void setQueue(SingleChronicleQueue queue) {
        this.queue = queue;
    }

    public void onAcquired(int cycle, File file) {
        if (this.queue == null || this.retention.disable()) {
            return;
        }
        log.debug("Acquire Chronicle file: {}, cycle: {}", (Object)file, (Object)cycle);
    }

    public synchronized void purge() {
        if (this.queue == null || this.queue.isClosed() || this.retention.disable() || !this.queue.file().exists()) {
            return;
        }
        List<Integer> cycles = this.getAllCycles();
        int cyclesToRemove = cycles.size() - this.retention.getRetentionCycles();
        if (cyclesToRemove <= 0) {
            return;
        }
        this.purgedStamp = System.currentTimeMillis();
        cycles.subList(0, cyclesToRemove).forEach(this::dropCycle);
        this.queue.createTailer();
    }

    protected void dropCycle(Integer cycle) {
        WireStore store = this.queue.storeForCycle(cycle.intValue(), this.queue.epoch(), false);
        if (store == null) {
            return;
        }
        File file = store.file();
        if (file == null || !file.exists()) {
            return;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = file::getAbsolutePath;
        supplierArray[1] = () -> this.retention;
        log.info("Deleting Chronicle file: {} according to retention: {}", supplierArray);
        try {
            Files.delete(file.toPath());
            this.queue.refreshDirectlyListing();
            log.debug(file + " deleted");
            this.queue.release((CommonStore)store);
        }
        catch (IOException | SecurityException e) {
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = file::getAbsolutePath;
            supplierArray2[1] = e::getMessage;
            log.warn("Unable to delete Chronicle file: {}, {}", supplierArray2);
        }
    }

    protected List<Integer> getAllCycles() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        try {
            NavigableSet allCycles = this.queue.listCyclesBetween(this.queue.firstCycle(), this.queue.lastCycle());
            allCycles.iterator().forEachRemaining(cycle -> ret.add(cycle.intValue()));
            return ret;
        }
        catch (ParseException e) {
            throw new StreamRuntimeException("Fail to list cycles for queue: " + this.queue, e);
        }
    }

    public void onReleased(int cycle, File file) {
        if (this.queue == null || this.queue.isClosed() || this.retention.disable()) {
            return;
        }
        log.debug("Release Chronicle file: {}, cycle: {}", (Object)file, (Object)cycle);
        if (this.checkPurge()) {
            this.purge();
        }
    }

    protected boolean checkPurge() {
        if (System.currentTimeMillis() - this.purgedStamp >= (long)this.retention.getRollCycle().length()) {
            return true;
        }
        log.debug("Skipping purge already done in within cycle duration: {}", (Object)this.purgedStamp);
        return false;
    }
}

