/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceListener;

public interface LogManager
extends AutoCloseable {
    public boolean exists(String var1);

    public boolean createIfNotExists(String var1, int var2);

    public boolean delete(String var1);

    public int size(String var1);

    public <M extends Externalizable> LogAppender<M> getAppender(String var1, Codec<M> var2);

    default public <M extends Externalizable> LogAppender<M> getAppender(String name) {
        return this.getAppender(name, NoCodec.NO_CODEC);
    }

    public <M extends Externalizable> LogTailer<M> createTailer(String var1, Collection<LogPartition> var2, Codec<M> var3);

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, Collection<LogPartition> partitions) {
        return this.createTailer(group, partitions, NoCodec.NO_CODEC);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, LogPartition partition) {
        return this.createTailer(group, partition, NoCodec.NO_CODEC);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, String name) {
        return this.createTailer(group, name, NoCodec.NO_CODEC);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, LogPartition partition, Codec<M> codec) {
        return this.createTailer(group, Collections.singletonList(partition), codec);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, String name, Codec<M> codec) {
        int partitions = this.size(name);
        if (partitions <= 0) {
            throw new IllegalArgumentException("Log name: " + name + " not found");
        }
        return this.createTailer(group, IntStream.range(0, partitions).boxed().map(partition -> new LogPartition(name, (int)partition)).collect(Collectors.toList()), codec);
    }

    public boolean supportSubscribe();

    public <M extends Externalizable> LogTailer<M> subscribe(String var1, Collection<String> var2, RebalanceListener var3, Codec<M> var4);

    default public <M extends Externalizable> LogTailer<M> subscribe(String group, Collection<String> names, RebalanceListener listener) {
        return this.subscribe(group, names, listener, NoCodec.NO_CODEC);
    }

    public List<LogLag> getLagPerPartition(String var1, String var2);

    default public LogLag getLag(String name, String group) {
        return LogLag.of(this.getLagPerPartition(name, group));
    }

    public <M extends Externalizable> List<Latency> getLatencyPerPartition(String var1, String var2, Codec<M> var3, Function<M, Long> var4, Function<M, String> var5);

    default public <M extends Externalizable> Latency getLatency(String name, String group, Codec<M> codec, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return Latency.of(this.getLatencyPerPartition(name, group, codec, timestampExtractor, keyExtractor));
    }

    @Deprecated
    default public <M extends Externalizable> List<Latency> getLatencyPerPartition(String name, String group, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return this.getLatencyPerPartition(name, group, NoCodec.NO_CODEC, timestampExtractor, keyExtractor);
    }

    @Deprecated
    default public <M extends Externalizable> Latency getLatency(String name, String group, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return this.getLatency(name, group, NoCodec.NO_CODEC, timestampExtractor, keyExtractor);
    }

    public List<String> listAll();

    public List<String> listConsumerGroups(String var1);

    @Override
    public void close();
}

