/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.log.chronicle.ChronicleCompoundLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogAppender;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogOffsetTracker;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.internals.AbstractLogManager;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;

public class ChronicleLogManager
extends AbstractLogManager {
    private static final Log log = LogFactory.getLog(ChronicleLogManager.class);
    protected final Path basePath;
    protected final ChronicleRetentionDuration retention;

    public ChronicleLogManager(Path basePath) {
        this(basePath, null);
    }

    public ChronicleLogManager(Path basePath, String retentionDuration) {
        this.basePath = basePath;
        this.retention = new ChronicleRetentionDuration(retentionDuration);
    }

    protected static void deleteQueueBasePath(Path basePath) {
        try {
            log.info((Object)("Removing Chronicle Queues directory: " + basePath));
            try (Stream<Path> paths = Files.list(basePath);){
                int count = (int)paths.filter(path -> path.toFile().isFile() && !ChronicleLogManager.isChronicleLogFile(path)).count();
                if (count > 0) {
                    String msg = "ChronicleLog basePath: " + basePath + " contains unknown files, please choose another basePath";
                    log.error((Object)msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            FileUtils.deleteDirectory((File)basePath.toFile());
        }
        catch (IOException e) {
            String msg = "Cannot remove Chronicle Queues directory: " + basePath + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected static boolean isChronicleLogFile(Path path) {
        String filename = path.getFileName().toString();
        return filename.endsWith(".cq4") || filename.endsWith(".cq4t") || "metadata.properties".equals(filename);
    }

    public String getBasePath() {
        return this.basePath.toAbsolutePath().toString();
    }

    @Override
    public boolean exists(String name) {
        boolean bl;
        block8: {
            Stream<Path> paths = Files.list(this.basePath.resolve(name));
            try {
                boolean bl2 = bl = paths.count() > 0L;
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            paths.close();
        }
        return bl;
    }

    @Override
    public void create(String name, int size) {
        ChronicleLogAppender.create(NoCodec.NO_CODEC, this.basePath.resolve(name).toFile(), size, this.retention).close();
    }

    @Override
    protected int getSize(String name) {
        return ChronicleLogAppender.partitions(this.basePath.resolve(name));
    }

    @Override
    public boolean delete(String name) {
        Path path = this.basePath.resolve(name);
        if (path.toFile().isDirectory()) {
            ChronicleLogManager.deleteQueueBasePath(path);
            return true;
        }
        return false;
    }

    protected LogLag getLagForPartition(String name, int partition, String group) {
        long pos;
        Path path = this.basePath.resolve(name);
        if (!ChronicleLogOffsetTracker.exists(path, group)) {
            pos = 0L;
        } else {
            try (ChronicleLogOffsetTracker offsetTracker = new ChronicleLogOffsetTracker(path.toString(), partition, group, ChronicleRetentionDuration.disableOf(this.retention));){
                pos = offsetTracker.readLastCommittedOffset();
            }
        }
        try (ChronicleLogAppender appender = ChronicleLogAppender.open(NoCodec.NO_CODEC, this.basePath.resolve(name).toFile());){
            long end = appender.endOffset(partition);
            if (pos == 0L) {
                pos = appender.firstOffset(partition);
            }
            long lag = appender.countMessages(partition, pos, end);
            long firstOffset = appender.firstOffset(partition);
            long endMessages = appender.countMessages(partition, firstOffset, end);
            LogLag logLag = new LogLag(pos, end, lag, endMessages);
            return logLag;
        }
    }

    @Override
    public List<LogLag> getLagPerPartition(String name, String group) {
        int size = this.size(name);
        ArrayList<LogLag> ret = new ArrayList<LogLag>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.getLagForPartition(name, i, group));
        }
        return ret;
    }

    public String toString() {
        return "ChronicleLogManager{basePath=" + this.basePath + ", retention='" + this.retention + "'}";
    }

    @Override
    public List<String> listAll() {
        List<String> list;
        block8: {
            Stream<Path> paths = Files.list(this.basePath);
            try {
                list = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid base path: " + this.basePath, e);
                }
            }
            paths.close();
        }
        return list;
    }

    @Override
    public List<String> listConsumerGroups(String name) {
        List<String> list;
        block9: {
            Path logRoot = this.basePath.resolve(name);
            if (!logRoot.toFile().exists()) {
                throw new IllegalArgumentException("Unknown Log: " + name);
            }
            Stream<Path> paths = Files.list(logRoot);
            try {
                list = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(ChronicleLogOffsetTracker::isOffsetTracker).map(ChronicleLogOffsetTracker::getGroupFromDirectory).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot access Log: " + name, e);
                }
            }
            paths.close();
        }
        return list;
    }

    @Override
    public <M extends Externalizable> CloseableLogAppender<M> createAppender(String name, Codec<M> codec) {
        return ChronicleLogAppender.open(codec, this.basePath.resolve(name).toFile(), this.retention);
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doCreateTailer(Collection<LogPartition> partitions, String group, Codec<M> codec) {
        ArrayList pTailers = new ArrayList(partitions.size());
        partitions.forEach(partition -> pTailers.add((ChronicleLogTailer)((ChronicleLogAppender)this.getAppender(partition.name(), codec)).createTailer((LogPartition)partition, group, codec)));
        if (pTailers.size() == 1) {
            return (LogTailer)pTailers.iterator().next();
        }
        return new ChronicleCompoundLogTailer(pTailers, group);
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doSubscribe(String group, Collection<String> names, RebalanceListener listener, Codec<M> codec) {
        throw new UnsupportedOperationException("subscribe is not supported by Chronicle implementation");
    }
}

