/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.renderer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageDecoder;
import org.nuxeo.lib.stream.codec.AvroSchemaStore;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.LogRecord;

public abstract class Renderer
implements Consumer<LogRecord<Record>> {
    protected int dataSize = 256;
    public static final byte[] AVRO_MESSAGE_V1_HEADER = new byte[]{-61, 1};

    public abstract void header();

    public abstract void footer();

    protected String watermarkString(long watermark) {
        if (watermark == 0L) {
            return "0";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Watermark wm = Watermark.ofValue(watermark);
        return String.format("%s:%d%s", dateFormat.format(new Date(wm.getTimestamp())), wm.getSequence(), wm.isCompleted() ? " completed" : "");
    }

    protected String tryToRenderAvroData(AvroSchemaStore store, Record record) {
        Object errorMessage;
        try {
            return this.renderAvroMessage(store, record);
        }
        catch (IllegalArgumentException e) {
            errorMessage = "";
        }
        catch (IllegalStateException e) {
            errorMessage = e.getMessage() + " data: ";
        }
        return (String)errorMessage + record.dataOverview(this.dataSize);
    }

    protected String renderAvroMessage(AvroSchemaStore store, Record record) {
        if (store == null || !this.isAvroMessage(record.getData())) {
            throw new IllegalArgumentException("Not avro encoded");
        }
        long fp = this.getFingerPrint(record.getData());
        Schema schema = store.findByFingerprint(fp);
        if (schema == null) {
            throw new IllegalStateException(String.format("Not found schema: 0x%08X", fp));
        }
        GenericData genericData = new GenericData();
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(genericData, schema);
        try {
            GenericRecord avroRecord = (GenericRecord)decoder.decode(record.getData(), null);
            return avroRecord.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error: %s decoding with schema: 0x%08X", e.getMessage(), fp));
        }
    }

    protected long getFingerPrint(byte[] data) {
        byte[] fingerPrintBytes = Arrays.copyOfRange(data, 2, 10);
        return ByteBuffer.wrap(fingerPrintBytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    protected boolean isAvroMessage(byte[] data) {
        return data.length >= 10 && data[0] == AVRO_MESSAGE_V1_HEADER[0] && data[1] == AVRO_MESSAGE_V1_HEADER[1];
    }
}

